/*
 * $Revision: 1.4 $ $Date: 2005/04/17 16:43:03 $
 * (C) 2004 SUGIMOTO Ken-ichi
 * 쐬: 2004/11/20
 */
package feat.v1.config;

import org.jibx.runtime.IUnmarshallingContext;

import feat.v1.InitializationException;
import feat.v1.ObjectUtil;
import feat.v1.Response;

public class DataDeclaration implements ResponseDeclaration {


    private Response response;
    private FeatureDeclaration featureDeclaration;

    // JiBX
    private String name;
    private String className;

    public DataDeclaration() {
    }

    public String getName() {
        return name;
    }

    /*public String getClassName() {
        return className;
    }*/

    public Response getResponse() {
        return response;
    }



    public FeatureDeclaration getFeatureDeclaration() {
        return featureDeclaration;
    }

    public void postset(IUnmarshallingContext uctx) {
        featureDeclaration = (FeatureDeclaration)uctx.getStackObject(1);
    }


    public void init() throws InitializationException {
        if ( className == null )
            throw new InitializationException("X|XNX̖Ow肳ĂȂ");
    }

    public void validate() throws InitializationException {
        try {
            Class responseClass = ObjectUtil.loadClass(className, getFeatureDeclaration().getPackage());
            if ( !Response.class.isAssignableFrom(responseClass) )
                throw new InitializationException(className+"Response̎NXł͂Ȃ");
            response = (Response) responseClass.newInstance();
        }
        catch (ClassNotFoundException ex) {
            throw new InitializationException("X|XNX \""+className+"\" Ȃ");
        }
        catch (IllegalAccessException ex) {
            throw new InitializationException(ex);
        }
        catch (InstantiationException ex) {
            throw new InitializationException(ex);
        }
    }

}
