/*
 * $Revision: 1.4 $ $Date: 2005/04/11 16:33:29 $
 * Copyright (C) 2004-2005 SUGIMOTO Ken-ichi
 * 쐬: 2004/10/2
 */
package feat.v1.config;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;

import org.jibx.runtime.IUnmarshallingContext;

import feat.v1.InitializationException;
import feat.v1.ObjectUtil;
import feat.v1.PreProcess;

public class PreProcessDeclaration implements ConfigElement {

    private ArrayList params;

    private Class preProcessClass;
    //private CommandDeclaration commandDecl;
    private PreProcess preProcess;
    private FeatureDeclaration featureDecl;

    // JiBX
    private String name;
    private boolean continueFlag;
    private String className;

    public String getName() {
        return name;
    }

    public PreProcessDeclaration() {
        continueFlag = false;
        params = new ArrayList();
    }

    public boolean isContinue() {
        return continueFlag;
    }

    public PreProcess getPreProcess() {
        return preProcess;
    }

    public Class getPreProcessClass() {
        return preProcessClass;
    }

    public void addParam(String param) {
        params.add(param);
    }




    public FeatureDeclaration getFeatureDeclaration() {
        return featureDecl;
    }

    /*public void setFeatureDeclaration(FeatureDeclaration featureDecl) {
        this.featureDecl = featureDecl;
    }*/

    public void postset(IUnmarshallingContext uctx) {
        featureDecl = (FeatureDeclaration)uctx.getStackObject(1);
    }


    public void init() throws InitializationException {
        if ( className == null )
            throw new InitializationException("vvZX̃NXw肳ĂȂ");
    }

    public void validate() throws InitializationException {
        try {
            preProcessClass = ObjectUtil.loadClass(
                    className,
                    getFeatureDeclaration().getPackage());
            // CX^X
            preProcess = (PreProcess) ObjectUtil.newInstance(
                    preProcessClass,
                    (String[]) params.toArray(new String[params.size()]));
        }
        catch (InstantiationException ex) {
            throw new InitializationException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new InitializationException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new InitializationException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new InitializationException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new InitializationException(ex);
        }
        catch (ClassNotFoundException ex) {
            throw new InitializationException(ex);
        }

    }

}
