/*
 * $Id: HTMLNodeImpl.java,v 1.2 2005/11/03 13:59:00 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2005/10/29
 */
package feat.v1.impl.template;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

import feat.v1.template.HTMLDocument;
import feat.v1.template.HTMLNode;
import feat.v1.template.NodeNotFoundException;

/**
 * HTMLNode̎B
 * @author SUGIMOTO Ken-ichi
 */
abstract public class HTMLNodeImpl implements HTMLNode {

    private static Log log = LogFactory.getLog(HTMLNodeImpl.class);

    public HTMLNodeImpl parent;
    public HTMLNodeImpl prev;
    public HTMLNodeImpl next;
    private Node domNode;

    abstract public void setFirstChild(HTMLNode child);

    public void setNext(HTMLNode next) {
        this.next = (HTMLNodeImpl)next;
    }

    public void setParent(HTMLNode parent) {
        this.parent = (HTMLNodeImpl)parent;
    }

    public void setPrev(HTMLNode prev) {
        this.prev = (HTMLNodeImpl)prev;
    }

    public void setDomNode(Node n) {
        domNode = n;
    }

    public Node getDomNode() {
        return domNode;
    }

    // HTMLNode̎ ------------------------------------------------------------

    public HTMLNode getParent() throws NodeNotFoundException {
        if ( parent == null )
            throw new NodeNotFoundException();
        return parent;
    }

    public HTMLDocument getDocument() throws NodeNotFoundException {
        for(HTMLNode node = this; true; node = node.getParent()) {
            if ( node.getNodeType() == HTMLNode.NODETYPE_DOCUMENT )
                return (HTMLDocument)node;
        }
    }

    abstract public HTMLNode getFirstChild() throws NodeNotFoundException;

    public HTMLNode getNext() throws NodeNotFoundException {
        if ( next == null )
            throw new NodeNotFoundException();
        return next;
    }

    public HTMLNode getPrev() throws NodeNotFoundException {
        if ( prev == null )
            throw new NodeNotFoundException();
        return prev;
    }

    public HTMLNode getFirst() {
        HTMLNode current = this;
        try {
            while(true) {
                current = current.getPrev();
            }
        }
        catch (NodeNotFoundException ex) {
        }
        return current;
    }

    public HTMLNode getLast() {
        HTMLNodeImpl current = this;
        while(current.next != null) {
            current = (HTMLNodeImpl)current.next;
        }
        return current;
    }

    public void insertAfter(HTMLNode node) {
        if ( node == null )
            return;

        // ̃m[hnodeA
        HTMLNodeImpl lastNode = (HTMLNodeImpl)node.getLast();
        lastNode.setNext(next);
        if ( next != null )
            ((HTMLNodeImpl)next).setPrev(lastNode);

        // ̃m[hnodeA
        next = (HTMLNodeImpl)node;
        ((HTMLNodeImpl)node).setPrev(this);

        // node̐em[hݒ
        TemplateUtil.setParentAll((HTMLNodeImpl)node, lastNode, parent);
    }

    public void insertBefore(HTMLNode node) {
        if ( node == null )
            return;

        // Õm[hnodeA
        if ( prev != null )
            ((HTMLNodeImpl)prev).setNext(node);
        ((HTMLNodeImpl)node).setPrev(prev);

        // node̍Ō̃m[hɁÃm[hA
        HTMLNodeImpl lastNode = (HTMLNodeImpl)node.getLast();
        lastNode.setNext(this);
        prev = lastNode;

        // KvȂΐem[h̍ŏ̎qm[hύX
        try {
            if ( parent != null && parent instanceof HTMLCompositeNodeImpl && parent.getFirstChild() == this ) {
                ((HTMLCompositeNodeImpl)parent).setFirstChild(node);
            }
        }
        catch (NodeNotFoundException ex) {
        }

        // node̐em[hݒ
        TemplateUtil.setParentAll((HTMLNodeImpl)node, lastNode, parent);
    }

    public void detach() {
        // eq̎QƂ؂
        if ( parent != null ) {
            HTMLNodeImpl parentNode = (HTMLNodeImpl)parent;

            // ̃m[hŏ̎qm[h
            // ̌Zm[hŏ̎qm[hɌJオ
            try {
                HTMLNodeImpl childNode = (HTMLNodeImpl)parentNode.getFirstChild();
                if ( childNode == this )
                    parentNode.setFirstChild(next);
            }
            catch (NodeNotFoundException ex) {
            }
            parent = null;
        }

        // Z̎QƂ؂
        if ( prev != null ) {
            ((HTMLNodeImpl)prev).setNext(next);
        }
        if ( next != null ) {
            ((HTMLNodeImpl)next).setPrev(prev);
        }
        prev = null;
        next = null;
    }


}
