/*
 * $Id: HTMLNodeListImpl.java,v 1.2 2005/11/03 09:41:47 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬F 2005/07/29
 */
package feat.v1.impl.template;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import feat.v1.template.HTMLNode;
import feat.v1.template.HTMLNodeList;


/**
 * m[h̃XgB
 * featev[gAPIDOM API̗ŎgpłB
 * @author SUGIMOTO
 */
public class HTMLNodeListImpl implements NodeList, HTMLNodeList {

    private List list;

    public HTMLNodeListImpl() {
        list = new ArrayList();
    }

    public void add(HTMLNode node) {
        list.add(node);
    }

    public int size() {
        return list.size();
    }

    public HTMLNode get(int index) {
        return (HTMLNode)list.get(index);
    }

    public Iterator iterator() {
        return Collections.unmodifiableList(list).iterator();
    }


    // NodeList̎

    public int getLength() {
        return size();
    }

    public Node item(int index) {
        return TemplateUtil.toDomNode(get(index));
    }
}
