/*
 * $Revision: 1.3 $ $Date: 2005/11/03 09:41:47 $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬F 2005/7/29
 */

package feat.v1.impl.template;

import feat.v1.template.HTMLAttribute;
import feat.v1.template.HTMLNode;
import feat.v1.template.NodeNotFoundException;

/**
 * ̊Ԃɂ󔒕B
 */
public class HTMLWhitespaceAttribute extends HTMLNodeImpl implements HTMLAttribute {

    private String str;

    HTMLWhitespaceAttribute(String str) {
        this.str = str;
    }

    public void setText(String str) {
        this.str = str;
    }

    /**
     * ǉB
     * @param str String
     */
    public void addText(String str) {
        this.str += str;
    }

    public String getText() {
        return str;
    }

    public String toString() {
        return str;
    }

    public void setFirstChild(HTMLNode child) {
    }

    // HTMLNode̎ -----------------------------------------------------------

    public HTMLNode getFirstChild() throws NodeNotFoundException {
        throw new NodeNotFoundException();
    }

    public String getValue() {
        return getText();
    }

    public HTMLNode copy(boolean deep) {
        return new HTMLWhitespaceAttribute(str);
    }

    public StringBuffer toHTML(StringBuffer buf) {
        return buf.append(str);
    }

    public int getNodeType() {
        return NODETYPE_ATTRIBUTE;
    }

}
