/*
 * $Id: TemplateUtil.java,v 1.5 2005/11/03 14:33:48 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬F 2005/07/28
 */
package feat.v1.impl.template;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import feat.v1.FeatRuntimeException;
import feat.v1.template.CompositeNode;
import feat.v1.template.HTMLNode;
import feat.v1.template.HTMLNodeList;
import feat.v1.template.NodeListIterator;
import feat.v1.template.NodeNotFoundException;


/**
 * ev[ĝ߂̃[eBeBB
 * @author SUGIMOTO
 */
public class TemplateUtil {

    /**
     * startȍ~̌Zm[hRs[Bm[hׂ͂Đ[Rs[B
     * @param start Rs[擪̃m[h
     * @param parent Rs[̃m[h
     * @return Rs[ꂽm[hBstartnull̂ƂnullԂB
     */
    public static HTMLNode copyNodeList(HTMLNodeImpl start, HTMLNode parent) {
        HTMLNode ret = null;
        HTMLNodeImpl prev = null;
        for(HTMLNodeImpl cur=start; cur != null; cur=cur.next) {
            HTMLNodeImpl cp = (HTMLNodeImpl)cur.copy(true);
            if ( ret == null ) {
                ret = cp;
            }
            if ( prev != null ) {
                prev.setNext(cp);
            }
            cp.setPrev(prev);
            cp.setParent(parent);

            prev = cp;
        }
        return ret;
    }

    public static StringBuffer nodeListToHTML(HTMLNode start, StringBuffer buf) {
        for(HTMLNode node=start; node != null; node=((HTMLNodeImpl)node).next) {
            node.toHTML(buf);
        }
        return buf;
    }

    /**
     * nodeƂȍ~̌Zm[hc[؂藣B
     * @param node null̂Ƃ͉Ȃ
     * @return 폜m[hBXg\͕ۂ邪em[hւ̎QƂ͂ȂȂĂ
     */
    public static HTMLNode detachAll(HTMLNode node) {
        if ( node == null )
            return null;

        // Õm[hƂ̎QƂ؂
        try {
            HTMLNodeImpl prev = (HTMLNodeImpl)(node.getPrev());
            prev.setNext(null);
        }
        catch (NodeNotFoundException ex) {
        }

        // em[h̎QƂ؂
        try {
            HTMLNodeImpl parent = (HTMLNodeImpl)(node.getParent());
            if ( parent.getFirstChild() == node ) {
                parent.setFirstChild(null);
            }
        }
        catch (NodeNotFoundException ex1) {
        }

        // em[hւ̎QƂ؂
        TemplateUtil.setParentAll((HTMLNodeImpl)node, null, null);

        return node;
    }

    /**
     * nodeƂȍ~̌Zm[hdest̎qm[hɒǉB
     * node܂destnull̏ꍇ͉ȂB
     * @param node
     * @param dest
     */
    public static void moveAll(HTMLNode node, HTMLNode dest) {
        if ( node == null || dest == null )
            return;
        detachAll(node);
        if ( dest instanceof CompositeNode ) {
            ((HTMLCompositeNodeImpl)dest).addChild(node);
        }
    }

    /**
     * startend܂ł̃m[h̐em[hnewParentɐݒ肷B
     * @param start Xg̍ŏ̃m[hBnull̂Ƃ͉ȂB
     * @param end Xg̍Ō̃m[hBnullw肷startȍ~ׂ̂Ẵm[hΏۂɂȂ
     * @param newParent
     */
    public static void setParentAll(HTMLNodeImpl start, HTMLNode end, HTMLNode newParent) {
        NodeListIterator it = new NodeListIterator(start);
        while( it.hasNext() ) {
            HTMLNodeImpl n = (HTMLNodeImpl)it.next();
            n.setParent(newParent);
            if ( n == end ) {
                break;
            }
        }
    }

    /**
     * nodeDOMNodeɕϊB
     * @param node ϊm[h܂null
     * @return nodeϊłȂnullȂnullԂ
     */
    public static Node toDomNode(HTMLNode node) {
        if ( node == null )
            return null;
        else if ( node instanceof HTMLNodeImpl )
            return ((HTMLNodeImpl)node).getDomNode();
        else
            throw new FeatRuntimeException("HTMLNodeDOMC^tF[XĂȂ");
    }

    public static NodeList toDomNodeList(HTMLNodeList list) {
        if ( list instanceof NodeList ) {
            return (NodeList)list;
        }
        else {
            return null;
        }

    }
}
