/*
 * $Id: OptionGroup.java,v 1.1 2005/12/18 03:26:21 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2005/12/08
 */
package feat.v1.template.form;

import java.util.ArrayList;
import java.util.List;

import feat.v1.template.HTMLElement;
import feat.v1.template.HTMLNode;
import feat.v1.template.NodeFactory;
import feat.v1.template.NodeIterator;
import feat.v1.template.NodeTreeIterator;

/**
 * Xg̑ĨO[vB
 * @author SUGIMOTO Ken-ichi
 */
public class OptionGroup implements ListItem {

    private HTMLElement element;

    public OptionGroup(String label) {
        element = NodeFactory.createHTMLElement("optgroup", false);
        element.setAttribute("label", label);
    }

    public OptionGroup(HTMLElement element) {
        this.element = element;
    }

    public String getLabel() {
        return element.getAttribute("label");
    }

    public void setLabel(String label) {
        element.setAttribute("label", label);
    }

    public HTMLElement getElement() {
        return element;
    }

    public void addOption(Option option) {
        element.addChild(option.getElement());
    }

    public Option[] getOptions() {
        List itemList = new ArrayList();
        for(NodeIterator it = new NodeTreeIterator(element); it.hasNext(); ) {
            HTMLNode node = it.nextNode();
            if ( node instanceof HTMLElement ) {
                HTMLElement e = (HTMLElement)node;
                if ( e.getTagName().equalsIgnoreCase("option") ) {
                    itemList.add(new Option(e));
                }
            }
        }
        return (Option[])itemList.toArray(new Option[itemList.size()]);
    }
}
