/*
 * $Id: TextArea.java,v 1.1 2005/12/18 03:26:21 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2005/12/18
 */
package feat.v1.template.form;

import feat.v1.template.HTMLElement;

/**
 * tH[̃eLXgGAB
 * @author SUGIMOTO Ken-ichi
 */
public class TextArea implements FormControl {

    private HTMLElement element;

    TextArea(HTMLElement element) {
        this.element = element;
    }

    public void setValue(String value) {
        if ( value != null && value.length() > 0 )
            element.setText(value);
        else
            element.clear();
    }

    public void setValues(String[] values) {
        if ( values != null && values.length > 0 )
            element.setAttribute("value", values[0]);
        else
            element.removeAttribute("value");
    }

    public String getValue() {
        return element.getString();
    }

    public String[] getValues() {
        return new String[] {element.getString()};
    }

    public HTMLElement getElement() {
        return element;
    }

    public int getType() {
        return TYPE_TEXTAREA;
    }

}
