/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.iterators;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import junit.framework.Assert;
import org.apache.commons.collections.OrderedMapIterator;
import org.apache.commons.collections.iterators.AbstractTestMapIterator;

public abstract class AbstractTestOrderedMapIterator
extends AbstractTestMapIterator {
    public AbstractTestOrderedMapIterator(String testName) {
        super(testName);
    }

    public final OrderedMapIterator makeEmptyOrderedMapIterator() {
        return (OrderedMapIterator)this.makeEmptyMapIterator();
    }

    public final OrderedMapIterator makeFullOrderedMapIterator() {
        return (OrderedMapIterator)this.makeFullMapIterator();
    }

    public void testEmptyMapIterator() {
        if (!this.supportsEmptyIterator()) {
            return;
        }
        super.testEmptyMapIterator();
        OrderedMapIterator it = this.makeEmptyOrderedMapIterator();
        Map map = this.getMap();
        Assert.assertEquals((boolean)false, (boolean)it.hasPrevious());
        try {
            it.previous();
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testFullMapIterator() {
        Object value;
        Object key;
        if (!this.supportsFullIterator()) {
            return;
        }
        super.testFullMapIterator();
        OrderedMapIterator it = this.makeFullOrderedMapIterator();
        Map map = this.getMap();
        Assert.assertEquals((boolean)true, (boolean)it.hasNext());
        Assert.assertEquals((boolean)false, (boolean)it.hasPrevious());
        HashSet<Object> set = new HashSet<Object>();
        while (it.hasNext()) {
            key = it.next();
            Assert.assertSame((String)"it.next() should equals getKey()", (Object)key, (Object)it.getKey());
            Assert.assertTrue((String)"Key must be in map", (boolean)map.containsKey(key));
            Assert.assertTrue((String)"Key must be unique", (boolean)set.add(key));
            value = it.getValue();
            if (!this.isGetStructuralModify()) {
                Assert.assertSame((String)"Value must be mapped to key", map.get(key), (Object)value);
            }
            Assert.assertTrue((String)"Value must be in map", (boolean)map.containsValue(value));
            Assert.assertEquals((boolean)true, (boolean)it.hasPrevious());
            this.verify();
        }
        while (it.hasPrevious()) {
            key = it.previous();
            Assert.assertSame((String)"it.previous() should equals getKey()", (Object)key, (Object)it.getKey());
            Assert.assertTrue((String)"Key must be in map", (boolean)map.containsKey(key));
            Assert.assertTrue((String)"Key must be unique", (boolean)set.remove(key));
            value = it.getValue();
            if (!this.isGetStructuralModify()) {
                Assert.assertSame((String)"Value must be mapped to key", map.get(key), (Object)value);
            }
            Assert.assertTrue((String)"Value must be in map", (boolean)map.containsValue(value));
            Assert.assertEquals((boolean)true, (boolean)it.hasNext());
            this.verify();
        }
    }

    public void testMapIteratorOrder() {
        Object key;
        if (!this.supportsFullIterator()) {
            return;
        }
        OrderedMapIterator it = this.makeFullOrderedMapIterator();
        Map map = this.getMap();
        Assert.assertEquals((String)"keySet() not consistent", new ArrayList(map.keySet()), new ArrayList(map.keySet()));
        Iterator it2 = map.keySet().iterator();
        Assert.assertEquals((boolean)true, (boolean)it.hasNext());
        Assert.assertEquals((boolean)true, (boolean)it2.hasNext());
        ArrayList<Object> list = new ArrayList<Object>();
        while (it.hasNext()) {
            key = it.next();
            Assert.assertEquals(it2.next(), (Object)key);
            list.add(key);
        }
        Assert.assertEquals((int)map.size(), (int)list.size());
        while (it.hasPrevious()) {
            key = it.previous();
            Assert.assertEquals(list.get(list.size() - 1), (Object)key);
            list.remove(list.size() - 1);
        }
        Assert.assertEquals((int)0, (int)list.size());
    }
}

