/*
 * Decompiled with CFR 0.152.
 */
package feat2;

import feat2.CommandContext;
import feat2.FeatError;
import feat2.FeatErrors;
import feat2.FeatException;
import feat2.FileResourceManager;
import feat2.HttpNotFoundException;
import feat2.Processor;
import feat2.Util;
import feat2.config.ConfigReader;
import feat2.config.ConfigurationException;
import feat2.config.FeatConfig;
import feat2.config.FeatureConfig;
import feat2.config.FileLocator;
import feat2.config.ServletFileLocator;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Iterator;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActionServlet
extends HttpServlet {
    private static final long serialVersionUID = Util.generateSerialVersion("$Id: ActionServlet.java,v 1.4 2006/04/20 15:25:49 sugimotokenichi Exp $");
    protected static Log log = LogFactory.getLog((Class)(class$feat2$ActionServlet == null ? (class$feat2$ActionServlet = ActionServlet.class$("feat2.ActionServlet")) : class$feat2$ActionServlet));
    private long checktime = 0L;
    private FileLocator configLocation;
    private Processor processor;
    static /* synthetic */ Class class$feat2$ActionServlet;

    public void init() throws ServletException {
        Util.setFeatConfig(this.getServletContext(), this.readConfig());
        this.processor = new Processor();
    }

    private FeatConfig readConfig() throws ServletException {
        FeatConfig ret = null;
        try {
            FileResourceManager rm = FileResourceManager.getInstance();
            FileLocator locator = this.getConfigFileLocation();
            ServletFileLocator appRoot = new ServletFileLocator("/", this.getServletContext());
            ret = ConfigReader.parseFeatConfig(appRoot, locator);
            FeatErrors errs = new FeatErrors(rm);
            boolean valid = ret.validate(errs);
            FeatError[] errors = errs.getErrors(10);
            if (!valid || errors.length > 0) {
                log.fatal((Object)"\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u8a18\u8ff0\u306b\u30a8\u30e9\u30fc\u304c\u3042\u308a\u307e\u3059");
                for (int i = 0; i < errors.length; ++i) {
                    log.fatal((Object)errors[i].getMessage());
                }
                throw new ServletException("\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u8a18\u8ff0\u306b\u30a8\u30e9\u30fc\u304c\u3042\u308a\u307e\u3059");
            }
            log.info((Object)rm.getString("config yomikomi kanryou", locator.toString(), null, null));
        }
        catch (FeatException ex) {
            log.fatal((Object)"ActionServlet\u306e\u521d\u671f\u5316\u4e2d\u306b\u30a8\u30e9\u30fc\u767a\u751f", (Throwable)ex);
            throw new ServletException((Throwable)ex);
        }
        catch (ConfigurationException ex) {
            log.fatal((Object)"\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u8a18\u8ff0\u306b\u30a8\u30e9\u30fc\u304c\u3042\u308a\u307e\u3059", (Throwable)ex);
            throw new ServletException((Throwable)ex);
        }
        catch (URISyntaxException ex) {
            throw new ServletException((Throwable)ex);
        }
        return ret;
    }

    private FileLocator getConfigFileLocation() throws ServletException {
        if (this.configLocation == null) {
            String configFilePath = this.getServletConfig().getInitParameter("config");
            if (configFilePath == null) {
                configFilePath = "/WEB-INF/feat-config.xml";
            }
            try {
                this.configLocation = new ServletFileLocator(configFilePath, this.getServletContext());
            }
            catch (URISyntaxException ex) {
                throw new ServletException((Throwable)ex);
            }
        }
        return this.configLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkConfig() throws ServletException {
        if (System.currentTimeMillis() - this.checktime > 1000L) {
            try {
                FileLocator locator = this.getConfigFileLocation();
                long lastUpdate = Util.getConfigLastUpdateTime(this.getServletContext());
                if (lastUpdate < locator.getLastModified()) {
                    boolean bl = true;
                    return bl;
                }
                FeatConfig conf = Util.getFeatConfig(this.getServletContext());
                Iterator it = conf.getFeatures();
                while (it.hasNext()) {
                    FeatureConfig fc = (FeatureConfig)it.next();
                    if (lastUpdate >= fc.getConfigFileLocator().getLastModified()) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            catch (IOException ex) {
                log.warn((Object)"", (Throwable)ex);
            }
            finally {
                this.checktime = System.currentTimeMillis();
            }
        }
        return false;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.process(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.process(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            ServletContext sctx = this.getServletContext();
            FeatConfig config = null;
            CommandContext cctx = null;
            ActionServlet actionServlet = this;
            synchronized (actionServlet) {
                if (this.checkConfig()) {
                    Util.setFeatConfig(sctx, this.readConfig());
                }
                config = Util.getFeatConfig(sctx);
                cctx = (CommandContext)req.getAttribute("feat.command_context.KEY");
                if (cctx == null) {
                    cctx = new CommandContext(config, sctx, req, resp);
                    req.setAttribute("feat.command_context.KEY", (Object)cctx);
                }
            }
            this.processor.process(cctx);
        }
        catch (HttpNotFoundException ex) {
            log.warn((Object)ex.getMessage(), (Throwable)ex);
            resp.sendError(404);
            return;
        }
        catch (FeatException ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

