/*
 * Decompiled with CFR 0.152.
 */
package feat2;

import feat2.FileResourceManager;
import feat2.StringUtil;
import java.util.HashMap;

public class FeatException
extends Exception {
    public static final int LEVEL_WARN = 1;
    public static final int LEVEL_ERROR = 2;
    public static final int LEVEL_FATAL = 3;
    private int level;
    private static final long serialVersionUID = "$Id: FeatException.java,v 1.2 2006/04/12 10:47:20 sugimotokenichi Exp $".hashCode();
    private String messageId;
    private HashMap keywords;

    public FeatException(Throwable cause, int level) {
        super(cause);
        this.level = level;
    }

    public FeatException(String message, int level) {
        super(message);
        this.level = level;
    }

    public FeatException(String message, Throwable cause, int level) {
        super(message, cause);
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public FeatException() {
        this.keywords = new HashMap();
    }

    public FeatException(String messageId, Throwable cause) {
        super(cause);
        this.messageId = messageId;
        this.keywords = new HashMap();
    }

    public FeatException(String messageId) {
        this.messageId = messageId;
        this.keywords = new HashMap();
    }

    public FeatException(Throwable cause) {
        super(cause);
        this.keywords = new HashMap();
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void addKeyword(String key, String word) {
        this.keywords.put(key, word);
    }

    public String getMessage() {
        String message = FileResourceManager.getInstance().getStringResource(this.messageId);
        if (message == null) {
            return this.messageId;
        }
        message = StringUtil.replaceParameters(message, this.keywords);
        return message;
    }
}

