/*
 * Decompiled with CFR 0.152.
 */
package feat2;

import feat2.Util;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;

public class StringUtil {
    public static String[] split(String str) {
        return StringUtils.split((String)str);
    }

    public static String[] split(String str, String delimitor) {
        return StringUtils.split((String)str, (String)delimitor);
    }

    public static String[] split(String str, char delim) {
        return StringUtils.split((String)str, (char)delim);
    }

    public static String join(String[] array, String str) {
        return StringUtils.join((Object[])array, (String)str);
    }

    public static String[] stripAll(String[] str) {
        return StringUtils.stripAll((String[])str);
    }

    public static String substringBefore(String str, String separator) {
        return StringUtils.substringBefore((String)str, (String)separator);
    }

    public static String capitalize(String str) {
        return WordUtils.capitalize((String)str);
    }

    public static String convertEncoding(String str, String encoding) throws UnsupportedEncodingException {
        return new String(str.getBytes("ISO-8859-1"), encoding);
    }

    public static String[] convertEncoding(String[] str, String encoding) throws UnsupportedEncodingException {
        String[] ret = new String[str.length];
        for (int i = 0; i < str.length; ++i) {
            ret[i] = StringUtil.convertEncoding(str[i], encoding);
        }
        return ret;
    }

    public static String escapeHTMLText(String str) {
        str = StringUtils.replace((String)str, (String)"&", (String)"&amp;");
        str = StringUtils.replace((String)str, (String)"<", (String)"&lt;");
        str = StringUtils.replace((String)str, (String)">", (String)"&gt;");
        str = StringUtils.replace((String)str, (String)"\"", (String)"&quot;");
        return str;
    }

    public static String unescapeHTMLText(String escaped) {
        escaped = StringUtils.replace((String)escaped, (String)"&lt;", (String)"<");
        escaped = StringUtils.replace((String)escaped, (String)"&gt;", (String)">");
        escaped = StringUtils.replace((String)escaped, (String)"&quot;", (String)"\"");
        escaped = StringUtils.replace((String)escaped, (String)"&amp;", (String)"&");
        return escaped;
    }

    public static String escapeJavaScriptString(String val) {
        return StringEscapeUtils.escapeJavaScript((String)val);
    }

    public static String replace(String str, String o, String n) {
        return StringUtils.replace((String)str, (String)o, (String)n);
    }

    public static String replaceParameters(String str, String[] values) {
        String[] names = new String[values.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = Integer.toString(i + 1);
        }
        return StringUtil.replaceParameters(str, names, values);
    }

    public static String replaceParameters(String str, Map keywords) {
        if (keywords.size() == 0) {
            return str;
        }
        String[] names = keywords.keySet().toArray(new String[0]);
        String[] values = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            values[i] = (String)keywords.get(names[i]);
        }
        return StringUtil.replaceParameters(str, names, values);
    }

    public static String replaceParameters(String str, String[] names, String[] values) {
        if (names.length == 0) {
            return str;
        }
        char[] c = str.toCharArray();
        StringBuffer buf = new StringBuffer(c.length * 6 / 5);
        StringBuffer name = new StringBuffer();
        int mode = 0;
        block5: for (int idx = 0; idx < c.length; ++idx) {
            switch (mode) {
                case 0: {
                    if (c[idx] == '$') {
                        mode = 1;
                        continue block5;
                    }
                    buf.append(c[idx]);
                    continue block5;
                }
                case 1: {
                    if (c[idx] == '$') {
                        buf.append('$');
                        mode = 0;
                        continue block5;
                    }
                    if (c[idx] != '{') continue block5;
                    mode = 2;
                    name.setLength(0);
                    continue block5;
                }
                case 2: {
                    if (c[idx] == '}') {
                        mode = 0;
                        String n = name.toString();
                        for (int i = 0; i < names.length; ++i) {
                            if (!names[i].equals(n)) continue;
                            buf.append(values[i]);
                        }
                        continue block5;
                    }
                    name.append(c[idx]);
                }
            }
        }
        return buf.toString();
    }

    public static String makeLocaleFilename(String baseName, Locale locale) {
        if (locale != null && !locale.equals(Util.NULL_LOCALE)) {
            int dotIdx = baseName.lastIndexOf(46);
            String ret = baseName.substring(0, dotIdx) + "." + locale.toString() + baseName.substring(dotIdx);
            return ret;
        }
        return baseName;
    }
}

