/*
 * Decompiled with CFR 0.152.
 */
package feat2.config;

import feat2.Action;
import feat2.CommandContext;
import feat2.FeatErrors;
import feat2.FeatRuntimeException;
import feat2.HTTPSessionException;
import feat2.config.ActionConfigBase;
import feat2.config.type.Scope;
import javax.servlet.http.HttpSession;

public class BeanConfig
extends ActionConfigBase {
    private Scope scope;

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public String getElementName() {
        return "bean";
    }

    public Action getActionInstance() {
        return new BeanAction(this.getActionClass(), this.getName().getValue());
    }

    public boolean validate(FeatErrors errs) {
        boolean ret = super.validate(errs);
        if (this.scope == null) {
            this.scope = new Scope("request");
        }
        return ret;
    }

    public class BeanAction
    implements Action {
        private Class beanClass;
        private String beanName;
        private Object bean;

        private BeanAction(Class beanClass, String beanName) {
            this.beanClass = beanClass;
            this.beanName = beanName;
        }

        public Object execute(CommandContext ctx) {
            return this.bean;
        }

        public Object getBean(CommandContext ctx) {
            if (BeanConfig.this.scope.isRequest()) {
                this.bean = ctx.getRequest().getAttribute(this.beanName);
                if (this.bean == null) {
                    this.bean = this.createBeanInstance();
                    ctx.getRequest().setAttribute(this.beanName, this.bean);
                }
            } else if (BeanConfig.this.scope.isSession()) {
                HttpSession session = ctx.getSession();
                if (session == null) {
                    throw new HTTPSessionException("Bean\u3092\u30bb\u30c3\u30c8\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f\u304c\u30bb\u30c3\u30b7\u30e7\u30f3\u304c\u5f97\u3089\u308c\u307e\u305b\u3093\u3067\u3057\u305f " + BeanConfig.this.getConfigPath());
                }
                this.bean = session.getAttribute(this.beanName);
                if (this.bean == null) {
                    this.bean = this.createBeanInstance();
                    session.setAttribute(this.beanName, this.bean);
                }
            } else if (!BeanConfig.this.scope.isUser() && BeanConfig.this.scope.isApplication()) {
                this.bean = ctx.getServletContext().getAttribute(this.beanName);
                if (this.bean == null) {
                    this.bean = this.createBeanInstance();
                    ctx.getServletContext().setAttribute(this.beanName, this.bean);
                }
            }
            return this.bean;
        }

        private Object createBeanInstance() {
            try {
                return this.beanClass.newInstance();
            }
            catch (InstantiationException ex) {
                throw new FeatRuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new FeatRuntimeException(ex);
            }
        }
    }
}

