/*
 * Decompiled with CFR 0.152.
 */
package feat2.config;

import feat2.FeatException;
import feat2.FileResourceManager;
import feat2.ObjectUtil;
import feat2.config.FeatConfig;
import feat2.config.FeatEntityResolver;
import feat2.config.FeatureConfig;
import feat2.config.FeatureRootConfig;
import feat2.config.FileLocator;
import feat2.config.Resources;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import javax.xml.parsers.FactoryConfigurationError;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class ConfigReader {
    private static Log log = LogFactory.getLog((Class)(class$feat2$config$ConfigReader == null ? (class$feat2$config$ConfigReader = ConfigReader.class$("feat2.config.ConfigReader")) : class$feat2$config$ConfigReader));
    static /* synthetic */ Class class$feat2$config$ConfigReader;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FeatConfig parseFeatConfig(FileLocator appRoot, FileLocator locator) throws FeatException {
        Digester digester = null;
        FeatConfig config = null;
        InputStream in = null;
        try {
            try {
                URL rule = (class$feat2$config$ConfigReader == null ? (class$feat2$config$ConfigReader = ConfigReader.class$("feat2.config.ConfigReader")) : class$feat2$config$ConfigReader).getClassLoader().getResource("feat2/rules/feat-config-rules.xml");
                digester = DigesterLoader.createDigester((URL)rule);
                digester.setEntityResolver((EntityResolver)new FeatEntityResolver());
                digester.setValidating(true);
                ConfigReader.addConverter(digester);
                in = new BufferedInputStream(locator.openInputStream());
                config = (FeatConfig)digester.parse(in);
                config.setAppRootLocator(appRoot);
                config.setConfigFileLocator(locator);
                Iterator it = config.getFeatures();
                while (it.hasNext()) {
                    FeatureConfig fc = (FeatureConfig)it.next();
                    String featureConfigFilename = fc.getConfigFilename();
                    if (featureConfigFilename != null) {
                        FileLocator featureConfigLocator = locator.newLocation(featureConfigFilename);
                        FeatureRootConfig feature = ConfigReader.parseFeature(featureConfigLocator);
                        fc.setFeatureRoot(feature);
                        fc.setConfigFileLocator(featureConfigLocator);
                        continue;
                    }
                    log.error((Object)FileResourceManager.getInstance().getStringResource("error.config.feature.configFilename.null"));
                }
                Object var12_14 = null;
                if (in == null) return config;
            }
            catch (FactoryConfigurationError ex) {
                throw new FeatException(ex, 3);
            }
            catch (SAXException ex) {
                throw new FeatException(ex, 3);
            }
            catch (IOException ex) {
                throw new FeatException(ex, 3);
            }
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ex) {}
        in.close();
        return config;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FeatureRootConfig parseFeature(FileLocator file) throws FeatException {
        Digester digester = null;
        FeatureRootConfig feature = null;
        InputStream in = null;
        try {
            try {
                digester = DigesterLoader.createDigester((URL)(class$feat2$config$ConfigReader == null ? (class$feat2$config$ConfigReader = ConfigReader.class$("feat2.config.ConfigReader")) : class$feat2$config$ConfigReader).getClassLoader().getResource("feat2/rules/feature-config-rules.xml"));
                digester.setEntityResolver((EntityResolver)new FeatEntityResolver());
                digester.setValidating(true);
                ConfigReader.addConverter(digester);
                in = new BufferedInputStream(file.openInputStream());
                feature = (FeatureRootConfig)digester.parse(in);
            }
            catch (FactoryConfigurationError ex) {
                throw new FeatException(ex, 3);
            }
            catch (SAXException ex) {
                throw new FeatException(ex, 3);
            }
            catch (IOException ex) {
                throw new FeatException(ex, 3);
            }
            Object var6_4 = null;
            if (in == null) return feature;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ex) {}
        in.close();
        return feature;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Resources parseResource(FileLocator file) throws FeatException {
        Digester digester = null;
        Resources resourcesDecl = null;
        InputStream in = null;
        try {
            try {
                digester = DigesterLoader.createDigester((URL)(class$feat2$config$ConfigReader == null ? (class$feat2$config$ConfigReader = ConfigReader.class$("feat2.config.ConfigReader")) : class$feat2$config$ConfigReader).getClassLoader().getResource("feat2/rules/resource-rules.xml"));
                ConfigReader.addConverter(digester);
                in = new BufferedInputStream(file.openInputStream());
                resourcesDecl = (Resources)digester.parse(in);
            }
            catch (IOException ex) {
                throw new FeatException("IOException - " + file, ex, 2);
            }
            catch (SAXException ex) {
                throw new FeatException("SAXException - " + file, ex, 2);
            }
            Object var6_4 = null;
            if (in == null) return resourcesDecl;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ex) {}
        in.close();
        return resourcesDecl;
    }

    private static void addConverter(Digester digester) {
        ConvertUtilsBean convertUtils = digester.getBeanUtils().getConvertUtils();
        ObjectUtil.setFeatConverters(convertUtils);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

