/*
 * Decompiled with CFR 0.152.
 */
package feat2.config;

import feat2.FeatErrors;
import feat2.config.CommandConfig;
import feat2.config.Config;
import feat2.config.ConfigError;
import feat2.config.ConfigUtil;
import feat2.config.type.Identifier;
import feat2.config.type.IdentifierList;
import java.util.ArrayList;

public class OutputConfig
extends Config {
    private Identifier name;
    private Identifier response;
    private ArrayList outputObjects = new ArrayList();

    public Identifier getResponse() {
        return this.response;
    }

    public void setResponse(Identifier response) {
        this.response = response;
    }

    public void setOutputObjects(IdentifierList nameList) {
        for (int i = 0; i < nameList.size(); ++i) {
            String name = nameList.get(i).getValue();
            Mapping mp = new Mapping(name, name);
            this.outputObjects.add(mp);
        }
    }

    public void addOutputMapping(Identifier localName, Identifier outputName) {
        Mapping o = new Mapping(localName.getValue(), outputName.getValue());
        this.outputObjects.add(o);
    }

    public Mapping[] getOutputMapping() {
        return this.outputObjects.toArray(new Mapping[0]);
    }

    public Identifier getName() {
        return this.name;
    }

    public void setName(Identifier name) {
        this.name = name;
    }

    public String getElementName() {
        return "output";
    }

    public boolean validate(FeatErrors errs) {
        boolean ret = true;
        ret = ret && ConfigUtil.validateRequired(this.name, "name", this, errs);
        ret = ret && ConfigUtil.validateRequired(this.response, "response", this, errs);
        String responseName = this.response.getValue();
        if (responseName != null && this.getFeatureConfig().getResponseConfig(responseName) == null) {
            errs.add(new ConfigError(responseName, "response", "referrence.response", 10, this));
        }
        CommandConfig commandConf = (CommandConfig)this.getParent();
        for (int i = 0; i < this.outputObjects.size(); ++i) {
            Mapping m = (Mapping)this.outputObjects.get(i);
            if (ConfigUtil.validateRequired(m.getLocalName(), "local-name", this, errs) && ConfigUtil.validateRequired(m.getOutputName(), "output-name", this, errs)) {
                if (commandConf.getActionComponentConfig(m.getLocalName()) != null) continue;
                errs.add(new ConfigError(m.getLocalName(), "local-name", "referrence", 10, this));
                continue;
            }
            ret = false;
        }
        return ret;
    }

    public class Mapping {
        String localName;
        String outputName;

        private Mapping(String localName, String outputName) {
            this.localName = localName;
            this.outputName = outputName;
        }

        public String getLocalName() {
            return this.localName;
        }

        public String getOutputName() {
            return this.outputName;
        }
    }
}

