/*
 * Decompiled with CFR 0.152.
 */
package feat2.impl;

import feat2.ApplicationException;
import feat2.CommandContext;
import feat2.FileUploadException;
import feat2.Processor;
import feat2.PropertyAccessException;
import feat2.Response;
import feat2.TemplateLoader;
import feat2.TemplateParsingException;
import feat2.View;
import feat2.config.PageConfig;
import feat2.config.ViewConfig;
import feat2.template.HTMLDocument;
import feat2.template.HTMLTemplate;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;

public class PageResponse
implements Response {
    private PageConfig pageConfig;

    public PageResponse(PageConfig config) {
        this.pageConfig = config;
    }

    public String output(CommandContext ctx) throws IOException, PropertyAccessException, TemplateParsingException, ApplicationException, FileUploadException {
        HTMLTemplate template = TemplateLoader.load(this.pageConfig.getTemplateFile(), ctx.getLocale(), null);
        String encoding = template.getEncoding();
        HTMLDocument doc = template.getDocument();
        String ret = this.processView(doc, ctx);
        if (ret != null) {
            return ret;
        }
        HttpServletResponse response = ctx.getResponse();
        response.setContentType("text/html;charset=" + encoding);
        PrintWriter writer = response.getWriter();
        ((Writer)writer).write(doc.toHTML());
        ((Writer)writer).flush();
        ((Writer)writer).close();
        return null;
    }

    private String processView(HTMLDocument doc, CommandContext ctx) throws PropertyAccessException, ApplicationException, FileUploadException {
        ViewConfig[] views = this.pageConfig.getViews();
        for (int i = 0; i < views.length; ++i) {
            Map values = Processor.processInputs(views[i], null, ctx);
            View view = views[i].getViewInstance();
            if (!Processor.processValidations(view, values, views[i], ctx)) {
                return views[i].getErrorResponse().getValue();
            }
            Processor.processInjection(view, values);
            try {
                view.format(doc, views[i], ctx);
                continue;
            }
            catch (Exception ex) {
                throw new ApplicationException(ex);
            }
        }
        return null;
    }
}

