/*
 * Decompiled with CFR 0.152.
 */
package feat2.impl;

import feat2.CommandContext;
import feat2.FeatRuntimeException;
import feat2.FileUploadException;
import feat2.Processor;
import feat2.PropertyAccessException;
import feat2.Response;
import feat2.StringUtil;
import feat2.config.RedirectConfig;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletOutputStream;

public class RedirectResponse
implements Response {
    private RedirectConfig config;

    public RedirectResponse(RedirectConfig config) {
        this.config = config;
    }

    public String output(CommandContext ctx) throws IOException, PropertyAccessException, FileUploadException {
        Map inputs = Processor.processInputs(this.config, null, ctx);
        String encoding = ctx.getCurrentFeatureConfig().getEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        if (this.config.getMethod().equalsIgnoreCase("get")) {
            String uri = this.config.getUri();
            String query = null;
            if (uri.indexOf(35) > -1) {
                uri = uri.substring(0, uri.indexOf(35));
            }
            if (uri.indexOf(63) > -1) {
                query = uri.substring(uri.indexOf(63) + 1);
                uri = uri.substring(0, uri.indexOf(63));
            }
            String[] pairs = StringUtil.split(query, '&');
            HashMap<String, String> queryMap = new HashMap<String, String>();
            if (pairs != null) {
                for (int i = 0; i < pairs.length; ++i) {
                    if (pairs[i].indexOf(61) > -1) {
                        String[] pair = StringUtil.split(pairs[i], '=');
                        queryMap.put(pair[0], pair[1]);
                        continue;
                    }
                    queryMap.put(pairs[i], "");
                }
            }
            Iterator keys = inputs.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String value = (String)inputs.get(key);
                queryMap.put(URLEncoder.encode(key, encoding), URLEncoder.encode(value, encoding));
            }
            StringBuffer queryBuf = new StringBuffer();
            Iterator it = queryMap.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                String val = (String)queryMap.get(key);
                if (query != null && query.length() > 0) {
                    queryBuf.append('&');
                }
                queryBuf.append(key);
                if (val == null || val.length() <= 0) continue;
                queryBuf.append('=');
                queryBuf.append(val);
            }
            String newUri = uri;
            if (queryBuf.length() > 0) {
                newUri = newUri + "?" + queryBuf.toString();
            }
            ctx.getResponse().sendRedirect(newUri);
        } else if (this.config.getMethod().equalsIgnoreCase("post")) {
            StringBuffer html = new StringBuffer();
            StringBuffer form = new StringBuffer();
            html.append("<html><head>");
            html.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=");
            html.append(encoding);
            html.append("\">\n");
            html.append("<script type=\"text/javascript\">\n<!--\n");
            html.append("function submitForm() {\n");
            form.append("<form name=\"form0\" method=\"post\" action=\"");
            form.append(this.config.getUri());
            form.append("\">\n");
            Iterator it = inputs.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                String val = (String)inputs.get(key);
                html.append("    document.forms[0]");
                html.append(".elements[\"").append(key).append("\"].value");
                html.append(" = \"");
                html.append(StringUtil.escapeJavaScriptString(val));
                html.append("\";\n");
                form.append("<input type=\"hidden\" name=\"").append(key);
                form.append("\">\n");
            }
            html.append("    document.forms[0].submit();\n");
            html.append("}\n//-->\n</script></head>\n");
            form.append("</form>\n");
            html.append("<body onLoad=\"submitForm();\">");
            html.append(form);
            html.append("</body></html>");
            ServletOutputStream out = ctx.getResponse().getOutputStream();
            out.write(html.toString().getBytes(encoding));
            out.flush();
            out.close();
        } else {
            throw new FeatRuntimeException("");
        }
        return null;
    }
}

