/*
 * Decompiled with CFR 0.152.
 */
package feat2.template.form;

import feat2.template.HTMLElement;
import feat2.template.form.FormControl;
import java.util.ArrayList;

public class CheckBox
implements FormControl {
    private HTMLElement[] elements;

    CheckBox(HTMLElement[] elements) {
        this.elements = elements;
    }

    public HTMLElement[] getElements() {
        return this.elements;
    }

    public HTMLElement[] getSelectedElements() {
        ArrayList<HTMLElement> list = new ArrayList<HTMLElement>();
        for (int i = 0; i < this.elements.length; ++i) {
            if (!this.elements[i].hasAttribute("checked")) continue;
            list.add(this.elements[i]);
        }
        return list.toArray(new HTMLElement[list.size()]);
    }

    public void setValue(String value) {
        for (int i = 0; i < this.elements.length; ++i) {
            String v = this.elements[i].getAttribute("value");
            if (v != null && value != null && v.equals(value)) {
                this.elements[i].setAttribute("checked", null);
                continue;
            }
            this.elements[i].removeAttribute("checked");
        }
    }

    public void setValues(String[] values) {
        if (values != null && values.length > 0) {
            for (int i = 0; i < values.length; ++i) {
                this.setValue(values[i]);
            }
        }
    }

    public String getValue() {
        String[] values = this.getValues();
        if (values.length > 0) {
            return values[0];
        }
        return null;
    }

    public String[] getValues() {
        HTMLElement[] selected = this.getSelectedElements();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < selected.length; ++i) {
            list.add(selected[i].getValue());
        }
        return list.toArray(new String[list.size()]);
    }

    public HTMLElement getElement() {
        if (this.elements.length > 0) {
            return this.elements[0];
        }
        return null;
    }

    public int getType() {
        return 512;
    }
}

