/*
 * Decompiled with CFR 0.152.
 */
package feat2.template.form;

import feat2.template.HTMLElement;
import feat2.template.form.FormControl;

public class RadioButton
implements FormControl {
    private HTMLElement[] elements;

    RadioButton(HTMLElement[] elements) {
        this.elements = elements;
    }

    public HTMLElement[] getElements() {
        return this.elements;
    }

    public HTMLElement getSelectedElement() {
        for (int i = 0; i < this.elements.length; ++i) {
            if (!this.elements[i].hasAttribute("checked")) continue;
            return this.elements[i];
        }
        return null;
    }

    public void setValue(String value) {
        for (int i = 0; i < this.elements.length; ++i) {
            String v = this.elements[i].getAttribute("value");
            if (v != null && value != null && v.equals(value)) {
                this.elements[i].setAttribute("checked", null);
                continue;
            }
            this.elements[i].removeAttribute("checked");
        }
    }

    public void setValues(String[] values) {
        if (values != null && values.length > 0) {
            this.setValue(values[0]);
        }
    }

    public String getValue() {
        HTMLElement elem = this.getSelectedElement();
        if (elem != null) {
            return elem.getAttribute("value");
        }
        return null;
    }

    public String[] getValues() {
        String value = this.getValue();
        if (value != null) {
            return new String[]{value};
        }
        return new String[0];
    }

    public HTMLElement getElement() {
        if (this.elements.length > 0) {
            return this.elements[0];
        }
        return null;
    }

    public int getType() {
        return 256;
    }
}

