/*
 * Decompiled with CFR 0.152.
 */
package feat2.template.form;

import feat2.template.HTMLElement;
import feat2.template.HTMLNode;
import feat2.template.NodeTreeIterator;
import feat2.template.form.FormControl;
import feat2.template.form.ListItem;
import feat2.template.form.Option;
import feat2.template.form.OptionGroup;
import java.util.ArrayList;

public class SelectControl
implements FormControl {
    private HTMLElement element;

    SelectControl(HTMLElement element) {
        this.element = element;
    }

    public ListItem[] getItems() {
        ArrayList<ListItem> itemList = new ArrayList<ListItem>();
        NodeTreeIterator it = new NodeTreeIterator(this.element);
        while (it.hasNext()) {
            HTMLNode node = it.nextNode();
            if (!(node instanceof HTMLElement)) continue;
            HTMLElement e = (HTMLElement)node;
            if (e.getTagName().equalsIgnoreCase("option")) {
                itemList.add(new Option(e));
                continue;
            }
            if (!e.getTagName().equalsIgnoreCase("optgroup")) continue;
            itemList.add(new OptionGroup(e));
        }
        return itemList.toArray(new ListItem[itemList.size()]);
    }

    public Option[] getOptions() {
        ArrayList<Option> itemList = new ArrayList<Option>();
        NodeTreeIterator it = new NodeTreeIterator(this.element);
        while (it.hasNext()) {
            HTMLElement e;
            HTMLNode node = it.nextNode();
            if (!(node instanceof HTMLElement) || !(e = (HTMLElement)node).getTagName().equalsIgnoreCase("option")) continue;
            itemList.add(new Option(e));
        }
        return itemList.toArray(new Option[itemList.size()]);
    }

    public void setItems(ListItem[] items) {
        this.element.clear();
        for (int i = 0; i < items.length; ++i) {
            this.element.addChild(items[i].getElement());
        }
    }

    public void addItem(ListItem item) {
        this.element.addChild(item.getElement());
    }

    public void clearItems() {
        this.element.clear();
    }

    public Option[] getSelectedElements() {
        ArrayList<Option> itemList = new ArrayList<Option>();
        Option[] options = this.getOptions();
        for (int i = 0; i < options.length; ++i) {
            if (!options[i].isSelected()) continue;
            itemList.add(options[i]);
        }
        return itemList.toArray(new Option[itemList.size()]);
    }

    public void setValue(String value) {
        Option[] options = this.getOptions();
        this.clearSelected(options);
        this.setValue(value, options);
    }

    private void clearSelected(Option[] options) {
        for (int i = 0; i < options.length; ++i) {
            options[i].setSelected(false);
        }
    }

    private void setValue(String value, Option[] options) {
        for (int i = 0; i < options.length; ++i) {
            String v = options[i].getValue();
            if (v == null || !v.equals(value)) continue;
            options[i].setSelected(true);
            break;
        }
    }

    public void setValues(String[] values) {
        Option[] options = this.getOptions();
        this.clearSelected(options);
        for (int i = 0; i < values.length; ++i) {
            this.setValue(values[i], options);
        }
    }

    public String getValue() {
        Option[] options = this.getOptions();
        for (int i = 0; i < options.length; ++i) {
            if (!options[i].isSelected()) continue;
            return options[i].getValue();
        }
        return null;
    }

    public String[] getValues() {
        ArrayList<String> values = new ArrayList<String>();
        Option[] options = this.getOptions();
        for (int i = 0; i < options.length; ++i) {
            if (!options[i].isSelected()) continue;
            values.add(options[i].getValue());
        }
        return values.toArray(new String[values.size()]);
    }

    public HTMLElement getElement() {
        return this.element;
    }

    public int getType() {
        return 1024;
    }
}

