/*
 * Decompiled with CFR 0.152.
 */
package feat2.template.impl;

import feat2.StringUtil;
import feat2.template.HTMLAttribute;
import feat2.template.HTMLNode;
import feat2.template.NodeNotFoundException;
import feat2.template.impl.DOMAttrImpl;
import feat2.template.impl.HTMLNodeImpl;

public class HTMLValuedAttribute
extends HTMLNodeImpl
implements HTMLAttribute {
    private String name;
    private String value;
    private String quote;

    HTMLValuedAttribute(String name, String rawValue) {
        this.name = name;
        this.value = rawValue;
        this.quote = "\"";
        this.setDomNode(new DOMAttrImpl(this));
    }

    public String getName() {
        return this.name;
    }

    public void setQuote(String quote) {
        this.quote = quote;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String value) {
        this.value = value == null ? null : StringUtil.escapeHTMLText(value);
    }

    public void setRawValue(String rawValue) {
        this.value = rawValue;
    }

    public String getQuote() {
        return this.quote;
    }

    public String toString() {
        return this.toHTML(new StringBuffer()).toString();
    }

    public void setFirstChild(HTMLNode child) {
    }

    public HTMLNode getFirstChild() throws NodeNotFoundException {
        throw new NodeNotFoundException();
    }

    public StringBuffer toHTML(StringBuffer buf) {
        if (this.name != null) {
            buf.append(this.name);
        }
        if (this.name != null && this.value != null) {
            buf.append("=");
        }
        if (this.value != null) {
            if (this.quote != null && this.quote.length() > 0 && !this.quote.equals("\u0000")) {
                buf.append(this.quote).append(this.value).append(this.quote);
            } else {
                buf.append(this.value);
            }
        }
        return buf;
    }

    public HTMLNode copy(boolean deep) {
        HTMLValuedAttribute ret = new HTMLValuedAttribute(this.name, this.value);
        ret.setQuote(this.quote);
        return ret;
    }

    public String getValue() {
        return StringUtil.unescapeHTMLText(this.value);
    }

    public int getNodeType() {
        return 2;
    }
}

