/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.iterators;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import junit.framework.Assert;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.iterators.AbstractTestIterator;

public abstract class AbstractTestMapIterator
extends AbstractTestIterator {
    public AbstractTestMapIterator(String testName) {
        super(testName);
    }

    public abstract MapIterator makeEmptyMapIterator();

    public abstract MapIterator makeFullMapIterator();

    public abstract Map getMap();

    public abstract Map getConfirmedMap();

    public final Iterator makeEmptyIterator() {
        return this.makeEmptyMapIterator();
    }

    public final Iterator makeFullIterator() {
        return this.makeFullMapIterator();
    }

    public boolean supportsSetValue() {
        return true;
    }

    public boolean isGetStructuralModify() {
        return false;
    }

    public Object[] addSetValues() {
        return new Object[]{"A", "B"};
    }

    public void testEmptyMapIterator() {
        if (!this.supportsEmptyIterator()) {
            return;
        }
        MapIterator it = this.makeEmptyMapIterator();
        Map map = this.getMap();
        Assert.assertEquals((boolean)false, (boolean)it.hasNext());
        try {
            it.next();
            Assert.fail();
        }
        catch (NoSuchElementException ex) {
            // empty catch block
        }
        try {
            it.getKey();
            Assert.fail();
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        try {
            it.getValue();
            Assert.fail();
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        if (!this.supportsSetValue()) {
            try {
                it.setValue(this.addSetValues()[0]);
                Assert.fail();
            }
            catch (UnsupportedOperationException ex) {
            }
            catch (IllegalStateException ex) {}
        } else {
            try {
                it.setValue(this.addSetValues()[0]);
                Assert.fail();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public void testFullMapIterator() {
        if (!this.supportsFullIterator()) {
            return;
        }
        MapIterator it = this.makeFullMapIterator();
        Map map = this.getMap();
        Assert.assertEquals((boolean)true, (boolean)it.hasNext());
        Assert.assertEquals((boolean)true, (boolean)it.hasNext());
        HashSet<Object> set = new HashSet<Object>();
        while (it.hasNext()) {
            Object key = it.next();
            Assert.assertSame((String)"it.next() should equals getKey()", (Object)key, (Object)it.getKey());
            Assert.assertTrue((String)"Key must be in map", (boolean)map.containsKey(key));
            Assert.assertTrue((String)"Key must be unique", (boolean)set.add(key));
            Object value = it.getValue();
            if (!this.isGetStructuralModify()) {
                Assert.assertSame((String)"Value must be mapped to key", map.get(key), (Object)value);
            }
            Assert.assertTrue((String)"Value must be in map", (boolean)map.containsValue(value));
            this.verify();
        }
    }

    public void testMapIteratorSet() {
        if (!this.supportsFullIterator()) {
            return;
        }
        Object newValue = this.addSetValues()[0];
        Object newValue2 = this.addSetValues().length == 1 ? this.addSetValues()[0] : this.addSetValues()[1];
        MapIterator it = this.makeFullMapIterator();
        Map map = this.getMap();
        Map confirmed = this.getConfirmedMap();
        Assert.assertEquals((boolean)true, (boolean)it.hasNext());
        Object key = it.next();
        Object value = it.getValue();
        if (!this.supportsSetValue()) {
            try {
                it.setValue(newValue);
                Assert.fail();
            }
            catch (UnsupportedOperationException ex) {
                // empty catch block
            }
            return;
        }
        Object old = it.setValue(newValue);
        confirmed.put(key, newValue);
        Assert.assertSame((String)"Key must not change after setValue", (Object)key, (Object)it.getKey());
        Assert.assertSame((String)"Value must be changed after setValue", (Object)newValue, (Object)it.getValue());
        Assert.assertSame((String)"setValue must return old value", (Object)value, (Object)old);
        Assert.assertEquals((String)"Map must contain key", (boolean)true, (boolean)map.containsKey(key));
        Assert.assertEquals((String)"Map must not contain old value", (boolean)confirmed.containsValue(old), (boolean)map.containsValue(old));
        Assert.assertEquals((String)"Map must contain new value", (boolean)true, (boolean)map.containsValue(newValue));
        this.verify();
        it.setValue(newValue);
        confirmed.put(key, newValue);
        Assert.assertSame((String)"Key must not change after setValue", (Object)key, (Object)it.getKey());
        Assert.assertSame((String)"Value must be changed after setValue", (Object)newValue, (Object)it.getValue());
        this.verify();
        it.setValue(newValue2);
        confirmed.put(key, newValue2);
        Assert.assertSame((String)"Key must not change after setValue", (Object)key, (Object)it.getKey());
        Assert.assertSame((String)"Value must be changed after setValue", (Object)newValue2, (Object)it.getValue());
        this.verify();
    }

    public void testRemove() {
        MapIterator it = this.makeFullMapIterator();
        Map map = this.getMap();
        Map confirmed = this.getConfirmedMap();
        Assert.assertEquals((boolean)true, (boolean)it.hasNext());
        Object key = it.next();
        if (!this.supportsRemove()) {
            try {
                it.remove();
                Assert.fail();
            }
            catch (UnsupportedOperationException ex) {
                // empty catch block
            }
            return;
        }
        it.remove();
        confirmed.remove(key);
        Assert.assertEquals((boolean)false, (boolean)map.containsKey(key));
        this.verify();
        try {
            it.remove();
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        this.verify();
    }

    public void testMapIteratorSetRemoveSet() {
        if (!this.supportsSetValue() || !this.supportsRemove()) {
            return;
        }
        Object newValue = this.addSetValues()[0];
        MapIterator it = this.makeFullMapIterator();
        Map map = this.getMap();
        Map confirmed = this.getConfirmedMap();
        Assert.assertEquals((boolean)true, (boolean)it.hasNext());
        Object key = it.next();
        it.setValue(newValue);
        it.remove();
        confirmed.remove(key);
        this.verify();
        try {
            it.setValue(newValue);
            Assert.fail();
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        this.verify();
    }

    public void testMapIteratorRemoveGetKey() {
        if (!this.supportsRemove()) {
            return;
        }
        MapIterator it = this.makeFullMapIterator();
        Map map = this.getMap();
        Map confirmed = this.getConfirmedMap();
        Assert.assertEquals((boolean)true, (boolean)it.hasNext());
        Object key = it.next();
        it.remove();
        confirmed.remove(key);
        this.verify();
        try {
            it.getKey();
            Assert.fail();
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        this.verify();
    }

    public void testMapIteratorRemoveGetValue() {
        if (!this.supportsRemove()) {
            return;
        }
        MapIterator it = this.makeFullMapIterator();
        Map map = this.getMap();
        Map confirmed = this.getConfirmedMap();
        Assert.assertEquals((boolean)true, (boolean)it.hasNext());
        Object key = it.next();
        it.remove();
        confirmed.remove(key);
        this.verify();
        try {
            it.getValue();
            Assert.fail();
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        this.verify();
    }
}

