/*
 * $Id: TemplateLoader.java,v 1.1 2006/04/11 16:14:32 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2005/04/03
 */
package feat2;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import feat2.config.BasicFileLocator;
import feat2.config.FileLocator;
import feat2.template.HTMLTemplate;
import feat2.template.HTMLTemplateParser;
import feat2.template.impl.HTMLParser15TemplateParser;

/**
 * Template[h邽߂̃NXB
 * @author SUGIMOTO Ken-ichi
 */
public class TemplateLoader {

    private static HTMLTemplateParser parser = new HTMLParser15TemplateParser();
    private static Map templateCache = new HashMap();
    //private static Map templateCache2 = new HashMap();

    /**
     * ݂̃P[̃ev[g[hȈՃ\bhB
     * @param file
     * @param encoding R[hBnullw肷HTML画f
     * @return
     * @throws TemplateParsingException ev[g̉͒ɃG[
     * @throws FileNotFoundException ev[gt@CȂ
     * @throws IOException HTMLf[^ǂݍݒIOO
     */
    public static HTMLTemplate load(File file, String encoding)
        throws FileNotFoundException, TemplateParsingException, IOException {

        FileLocator fl = new BasicFileLocator(file);
        return load(fl, Locale.getDefault(), encoding);
    }

    /*public static NekoHTMLTemplate load(File file) throws FileNotFoundException, TemplateParsingException {
        FileLocator fl = new BasicFileLocator(file);
        return load(fl, Locale.getDefault());
    }*/

    /**
     *
     * @param file
     * @param locale
     * @param encoding R[hBnullw肷HTML画f
     * @return
     * @throws FileNotFoundException ev[gt@CȂ
     * @throws TemplateParsingException ev[g̉͒ɃG[
     * @throws IOException HTMLf[^ǂݍݒIOO
     */
    public static HTMLTemplate load(FileLocator file, Locale[] locale, String encoding) throws FileNotFoundException, TemplateParsingException, IOException {

        HTMLTemplate template = null;

        for (int i = 0; i < locale.length; i++) {

            template = load(file, locale[i], encoding);
            if ( template != null )
                return template;

        }

        // P[̃ev[gƂ̓ftHgP[̃ev[g

        template = load(file, Util.NULL_LOCALE, encoding);
        if ( template == null )
            throw new FileNotFoundException(file.getURIString());

        return template;

    }

    /**
    *
    * @param file
    * @param locale
    * @param encoding R[hBnullw肷HTML画f
    * @return t@CȂnull
    * @throws TemplateParsingException ev[g̉͒ɃG[
    * @throws IOException HTMLf[^ǂݍݒIOO
    */
   private static HTMLTemplate load(FileLocator file, Locale locale, String encoding) throws TemplateParsingException, IOException {

       // P[Ƀ}b`錾ꖼ̃Xg

       List seq = null;
       if ( locale != Util.NULL_LOCALE )
           seq = Util.expandLocale(locale);
       else {
           seq = new ArrayList();
           seq.add(Util.NULL_LOCALE);
       }

       HTMLTemplate ret = null;
       synchronized(templateCache) {

           for(int i=0; i<seq.size(); i++) {

               // ꖼ܂񂾃t@C

               String filename = StringUtil.makeLocaleFilename(file.getFilename(), (Locale)seq.get(i));
               FileLocator f = file.newLocation(filename);
               String uristr = f.getURIString();

               // ev[gLbV̒ɗLȃev[g邩H

               TemplateCacheEntry entry = (TemplateCacheEntry)templateCache.get(uristr);
               if ( entry != null ) {

                   // LbṼev[g܂LȂ炱̃t@CԂ

                   if ( entry.isValid() ) {
                       ret = entry.getTamplate();
                       break;
                   }

                   // LbṼev[g؂ȂLbV

                   else {
                        templateCache.put(uristr, null);
                   }

               }

               // t@C烍[h

               if ( f.exists() ) {
                   ret = parser.parseTemplate(f, encoding);
                   entry = new TemplateCacheEntry(f, ret);
                   templateCache.put(uristr, entry);
                   break;
               }

           }

       }

       return ret;

   }

   /*
   *
   * @param file
   * @param locale
   * @return
   * @throws TemplateParsingException ev[g̉͒ɃG[
   * @throws FileNotFoundException ev[gt@CȂ
   */
   /*public static NekoHTMLTemplate load(FileLocator file, Locale locale) throws TemplateParsingException, FileNotFoundException {
       // P[Ƀ}b`錾ꖼ̃Xg
       List seq = Util.makeSequence(locale);
       seq.add(Util.NULL_LOCALE);

       NekoHTMLTemplate ret = null;
       synchronized(templateCache) {
           for(int i=0; i<seq.size(); i++) {
               // ꖼ܂񂾃t@C
               String filename = StringUtil.makeLocaleFilename(file.getFilename(), (Locale)seq.get(i));
               FileLocator f = file.newLocation(filename);
               String uristr = f.getURIString();

               // ev[gLbV̒ɗLȃev[g邩H
               ret = (NekoHTMLTemplate)templateCache2.get(uristr);
               if ( ret != null ) {

                   // t@C܂LȂ炱̃t@CԂ
                   if ( ret.isValid() ) {
                       break;
                   }
                   // t@CȂLbV
                   else {
                          templateCache.put(uristr, null);
                   }
               }

               // t@C烍[h
               if ( f.exists() ) {
                   ret = new NekoHTMLTemplate(f);
                   templateCache.put(uristr, ret);
                   break;
               }

           }
       }
       if ( ret == null )
           throw new FileNotFoundException(file.getURIString());
       return ret;
   }*/

}

class TemplateCacheEntry {

    FileLocator file;
    HTMLTemplate template;
    long lastModified;

    TemplateCacheEntry(FileLocator file, HTMLTemplate template) {
        this.file = file;
        this.template = template;
        try {
            lastModified = file.getLastModified();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    /**
     * t@C݂ĂāAXVĂȂtrueB
     * @return boolean
     */
    public boolean isValid() {
        try {
            return exists() && !checkFile();
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean exists() {
        return file != null && file.exists();
    }

    /**
     * t@CXVĂtrueԂB
     * @param locator FileLocator
     * @return boolean
     */
    private boolean checkFile() throws IOException {
        long lastModified = file.getLastModified();
        if ( this.lastModified != lastModified ) {
            return true;
        }
        return false;
    }

    public HTMLTemplate getTamplate() {
        return template;
    }
}
