/*
 * $Id: ValidationError.java,v 1.2 2006/04/21 15:04:21 sugimotokenichi Exp $
 * Copyright (C) 2006 SUGIMOTO Ken-ichi
 * 쐬: 2006/02/21
 */

package feat2;

import java.util.HashMap;

import feat2.config.Config;
import feat2.config.ValidationConfig;

public class ValidationError implements FeatError {

    private String featureName;
    private ValidationConfig config;
    private String messageId;
    private ResourceManager rm;
    private HashMap keywords;

    public ValidationError(String messageId, ValidationConfig validationConfig) {

        this.messageId = messageId;
        this.featureName = validationConfig.getFeatureConfig().getName().getValue();
        this.config = validationConfig;
        keywords = new HashMap();
    }

    public String getFeatureName() {
        return featureName;
    }

    public String getMessageId() {
        return messageId;
    }

    public String getValidationName() {
        return config.getName().getValue();
    }

    /**
     * of[V̐ݒIuWFNgԂB
     */
    public Config getComponentConfig() {
        return config;
    }

    public int getErrorLevel() {
        return ERROR;
    }

    public void setResourceManager(ResourceManager rm) {
        this.rm = rm;
    }

    public void addKeyrowd(String key, String value) {
        keywords.put(key, value);
    }

    public String getMessage() throws IllegalStateException {

        String ret = getResource(messageId);

        if ( ret != null ) {
            ret = StringUtil.replaceParameters(ret, keywords);
        }

        return ret;
    }

    private String getResource(String name) {

        if ( name == null)
            return null;

        String ret = null;

        // w肳ꂽ\[X}l[W烊\[X擾łȂ
        // VXẽ\[X}l[W烊\[X擾

        if ( rm != null )
            ret = rm.getStringResource(name);

        if ( ret == null )
            ret = FileResourceManager.getInstance().getStringResource(name);

        if ( ret == null )
            ret = name;

        return ret;

    }



}
