/*
 * $Id: ActionConfigBase.java,v 1.3 2006/04/21 15:04:21 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2006/02/20
 */
package feat2.config;

import feat2.Action;
import feat2.FeatError;
import feat2.FeatErrors;
import feat2.config.type.Identifier;
import feat2.config.type.JavaIdentifier;

/**
 * ʂo͂R|[lgB
 * @author SUGIMOTO Ken-ichi
 */
abstract public class ActionConfigBase extends Config implements DIComponentConfig, ValidatableComponentConfig {

    private Identifier name;
    private JavaIdentifier className;
    private InputSupport inputs;
    private ValidationSupport validations;
    private Class actionClass;
    private Identifier errorResponse;

    public ActionConfigBase() {
        inputs = new InputSupport(this);
        validations = new ValidationSupport(this);
    }

    public Identifier getName() {
        return name;
    }
    public void setName(Identifier name) {
        this.name = name;
    }

    public JavaIdentifier getClassName() {
        return className;
    }
    public void setClassName(JavaIdentifier className) {
        this.className = className;
    }

    public Identifier getErrorResponse() {
        return errorResponse;
    }
    public void setErrorResponse(Identifier errorResponse) {
        this.errorResponse = errorResponse;
    }

    protected Class getActionClass() {
        return actionClass;
    }

    abstract public Action getActionInstance();

    // DIComponentConfig̃\bh -----------------------------------------------

    public void addInput(InputConfigBase input) {
        inputs.addInput(input);
    }

    public InputConfigBase[] getInputs() {
        return inputs.getInputs();
    }

    public InputConfigBase getInputConfig(String propertyName) {
        return inputs.getInputConfig(propertyName);
    }


    // ValidatableComponentConfig̃\bh -----------------------------------------

    public void addValidation(ValidationConfig validation) {
        validations.addValidation(validation);
    }
    public ValidationConfig[] getValidations() {
        return validations.getValidations();
    }

    public ValidationConfig getValidationConfig(String name) {
        return validations.getValidationConfig(name);
    }

    public String getPropertyNameId(String propertyName) {
        return inputs.getInputConfig(propertyName).getDisplayName();
    }


    // Config̃\bh -------------------------------------------------------

    public boolean validate(FeatErrors errs) {

        boolean ret = true;

        // name

        ret = ret && ConfigUtil.validateRequired(name, "name", this, errs);

        // className

        actionClass = ConfigUtil.validateClass(className, "class", this, errs);
        if ( actionClass == null )
            ret = false;

        // errorResponse

        if ( validations.count() > 0 ) {

            if ( errorResponse == null ) {
                errs.add( new ConfigError(null, "error-response", ConfigError.TYPE_ERROR_RESPONSE, FeatError.ERROR, this) );
            }
            else {
                String responseName = errorResponse.getValue();
                if ( getFeatureConfig().getResponseConfig(responseName) == null ) {
                    errs.add( new ConfigError(responseName, "error-response", ConfigError.TYPE_REFERRENCE_RESPONSE, FeatError.ERROR, this) );
                }
            }

        }

        // inputs

        ret = ( ret && inputs.validate(errs) );

        // validations

        ret = ( ret && validations.validate(errs) );

        return ret;

    }


}
