/*
 * $Id: ConfigurationException.java,v 1.3 2006/04/23 15:50:23 sugimotokenichi Exp $
 * Copyright (C) 2006 SUGIMOTO Ken-ichi
 * 쐬: 2006/03/07
 */
package feat2.config;

import java.util.HashMap;

import feat2.FeatRuntimeException;
import feat2.FileResourceManager;
import feat2.StringUtil;

/**
 * ݒ̋Lq~XƂȂꍇ̗OB
 * TODO ^COɕύX̂ŁALb`ĂƂKv
 * @author SUGIMOTO Ken-ichi
 */
public class ConfigurationException extends FeatRuntimeException {

    private static final long serialVersionUID = "$Id: ConfigurationException.java,v 1.3 2006/04/23 15:50:23 sugimotokenichi Exp $".hashCode();

    private String messageId;
    private HashMap keywords;

    public ConfigurationException(String messageId, Throwable cause) {
        super(cause);
        this.messageId = messageId;
        this.keywords = new HashMap();
    }

    public ConfigurationException(String messageId) {
        super();
        this.messageId = messageId;
        this.keywords = new HashMap();
    }

    public ConfigurationException(Throwable cause) {
        super(cause);
        this.keywords = new HashMap();
    }

    public String getMessageId() {
        return messageId;
    }

    /**
     * bZ[W̃L[[huǉB
     * @param key
     * @param word
     */
    public void addKeyword(String key, String word) {
        keywords.put(key, word);
    }

    /**
     * bZ[WIDɑΉG[bZ[WԂB
     * \[X}l[W̓ftHgFileResourceManagergB
     * \[XȂƂ̓\[XIDԂB
     */
    public String getMessage() {
        if ( messageId != null ) {
            String message = FileResourceManager.getInstance().getStringResource(messageId);
            if ( message == null )
                return messageId;
            message = StringUtil.replaceParameters(message, keywords);
            return message;
        }
        else
            return null;
    }

}
