/*
 * $Id: Dependencies.java,v 1.1 2006/04/11 16:14:32 sugimotokenichi Exp $
 * Copyright (C) 2006 SUGIMOTO Ken-ichi
 * 쐬: 2006/03/06
 */
package feat2.config;

import java.util.ArrayList;

class Dependencies {

    private ArrayList dependencies;

    Dependencies() {
        dependencies = new ArrayList();
    }

    /**
     * ˑ֌WǉBfrom, tõIuWFNgƂ̊֌Wo^B
     * @param from
     * @param to
     */
    void addDependency(Object from, Object to) {
        Dependency d = getDependency(from);
        if ( d == null ) {
            d = new Dependency(from);
            dependencies.add(d);
        }
        d.addDepend(to);

        // ˑ̃IuWFNg

        getDependency(to);
    }

    private Dependency getDependency(Object o) {
        for(int i=0; i<dependencies.size(); i++) {
            Dependency d = (Dependency)dependencies.get(i);
            if ( d.obj == o )
                return d;
        }
        return null;
    }

    /**
     * w̃IuWFNg̈ˑAIuWFNgւ̈ˑ폜B
     * @param o
     */
    void removeDependencies(Object o) {
        Dependency rem = null;

        // ̃IuWFNg̈ˑ폜
        for(int i=0; i<dependencies.size(); i++) {
            Dependency d = (Dependency)dependencies.get(i);
            d.removeDepend(o);
            if ( d.obj == o )
                rem = d;
        }

        // ̃IuWFNg̈ˑ폜
        if ( rem != null )
            dependencies.remove(rem);
    }

    /**
     * ǂ̃IuWFNgɂˑȂIuWFNgԂB
     * @return
     */
    Object getIndependentObject() {
        for(int i=0; i<dependencies.size(); i++) {
            Dependency d = (Dependency)dependencies.get(i);
            if ( d.countDepends() == 0 )
                return d.obj;
        }
        return null;
    }

    int count() {
        return dependencies.size();
    }

}