/*
 * $Id: FeatureConfig.java,v 1.2 2006/04/12 10:47:21 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2006/02/20
 */
package feat2.config;

import java.util.Locale;

import feat2.FeatError;
import feat2.FeatErrors;
import feat2.config.type.Identifier;
import feat2.config.type.JavaIdentifier;


/**
 * featݒt@C̃tB[`[̐ݒB
 * @author SUGIMOTO Ken-ichi
 */
public class FeatureConfig extends Config {

    private String templatePath;
    private String configFilename;
    private FileLocator configFileLocator;
    private FeatureRootConfig featureRoot;

    public FeatureConfig() {
    }

    // vpeB -------------------------------------------------------------

    public String getConfigFilename() {
        return configFilename;
    }
    public void setConfigFilename(String configFile) {
        this.configFilename = configFile;
    }

    public String getTemplatePath() {
        return templatePath;
    }
    public void setTemplatePath(String templateDir) {
        this.templatePath = templateDir;
    }

    public void setFeatureRoot(FeatureRootConfig conf) {
        featureRoot = conf;
        featureRoot.setParent(this);
    }

    public FileLocator getConfigFileLocator() {
        return configFileLocator;
    }

    /**
     * ̃vpeBConfigReaderZbgB
     * @param configFileLocator
     */
    public void setConfigFileLocator(FileLocator configFileLocator) {
        this.configFileLocator = configFileLocator;
    }

    // FeatureRootConfig̈Ϗ\bh ----------------------------------------

    public String getEncoding() {
        return featureRoot.getEncoding();
    }

    public Identifier getName() {
        return featureRoot.getName();
    }

    public JavaIdentifier getPackageName() {
        return featureRoot.getPackageName();
    }

    public Boolean getCreateSession() {
        return featureRoot.getCreateSession();
    }

    public CommandConfig getCommandConfig(String commandName) {
        return featureRoot.getCommandConfig(commandName);
    }

    public ResponseConfigBase getResponseConfig(String name) {
        return featureRoot.getResponseConfig(name);
    }

    public String getStringResource(String resourceName, Locale locale) {
        return featureRoot.getStringResource(resourceName, locale);
    }

    public Resources getResources() {
        return featureRoot.getResources();
    }

    public InterceptConfig[] getInterceptConfigs() {
        return featureRoot.getInterceptConfigs();
    }

    public ExceptionConfig getException(Class exclass) {
        return featureRoot.getException(exclass);
    }


    // Config̃\bh -------------------------------------------------------

    public String getElementName() {
        return "feature";
    }

    public boolean validate(FeatErrors errs) {

        boolean ret = true;

        // templatePath

        if ( templatePath == null )
            errs.add(new ConfigError(templatePath, "template-path", ConfigError.TYPE_NULL, FeatError.ERROR, this));

        // featureRoot

        ret = ret && featureRoot.validate(errs);

        // configFilename͂̃\bhOɎĝŌ؂Ȃ

        return ret;

    }


}
