/*
 * $Id: JavaIdentifier.java,v 1.1 2006/04/11 16:14:32 sugimotokenichi Exp $
 * Copyright (C) 2006 SUGIMOTO Ken-ichi
 * 쐬: 2006/03/10
 */
package feat2.config.type;

import feat2.validation.ValidatorUtil;

/**
 * Java̎ʎq('.'ŋ؂ꂽpX`܂)B
 * @author SUGIMOTO Ken-ichi
 */
public class JavaIdentifier {

    private String value;

    public JavaIdentifier() {
        value = null;
    }

    public JavaIdentifier(String identifier) throws IllegalArgumentException {

        if ( !isJavaIdentifierPath(identifier) )
            throw new IllegalArgumentException(); // TODO G[bZ[W

        this.value = identifier;
    }



    // Object̃\bh

    public boolean equals(Object obj) {
        return value.equals( ((JavaIdentifier)obj).getValue() );
    }

    public int hashCode() {
        return value.hashCode();
    }

    public String toString() {
        return value;
    }



    // vpeB -------------------------------------------------------------

    public String getValue() {
        return value;
    }


    // X^eBbN\bh ---------------------------------------------------

    /**
     * Javaʎq̃pX("aaa.bbb.ccc"Ȃ)ȂtrueԂB
     * @param string
     * @return
     */
    public static boolean isJavaIdentifierPath(String string) {

        if ( ValidatorUtil.isBlankOrNull(string) )
            return false;

        // '.'ŕ

        String[] tokens = null;
        if ( string.indexOf('.') > -1 ) {
            tokens = string.split("\\.");
        }
        else {
            return isJavaIdentifier(string);
        }

        for (int i = 0; i < tokens.length; i++) {
            if ( !isJavaIdentifier(tokens[i]) )
                return false;
        }

        return true;
    }


    /**
     * JavaʎqȂtrueԂB
     * @param string
     * @return
     */
    public static boolean isJavaIdentifier(String string) {

        // ܂܂Ȃfalse

        if ( ValidatorUtil.isBlankOrNull(string) )
            return false;

        // ŏ̕

        if ( !Character.isJavaIdentifierStart(string.charAt(0)) )
            return false;

        // 2ڈȍ~

        for (int i = 1; i < string.length(); i++) {
            if ( !Character.isJavaIdentifierPart(string.charAt(i)) )
                return false;
        }

        return true;

    }

}
