/*
 * $Id: ObjectRef.java,v 1.1 2006/04/11 16:14:32 sugimotokenichi Exp $
 * Copyright (C) 2006 SUGIMOTO Ken-ichi
 * 쐬: 2006/03/15
 */
package feat2.config.type;

import java.util.regex.Pattern;

import feat2.validation.ValidatorUtil;

/**
 * IuWFNg̎QƎB
 * @author SUGIMOTO Ken-ichi
 */
public class ObjectRef {

    private String name;
    private String nestedPropertyName;

    public ObjectRef() {
    }

    public ObjectRef(String ref) throws IllegalArgumentException {

        int dotIdx = ref.indexOf('.');
        if ( dotIdx == -1 ) {

            // vpeB̎w肪Ȃꍇ

            if ( Identifier.isIdentifier(ref) ) {
                this.name = ref;
                this.nestedPropertyName = null;
            }
            else {
                throw new IllegalArgumentException(); // TODO G[bZ[W
            }

        }
        else {

            // vpeBw肳ꂽQƎ

            name = ref.substring(0, dotIdx);
            nestedPropertyName = ref.substring(dotIdx+1);

            // IuWFNg
            if ( !Identifier.isIdentifier(name) )
                throw new IllegalArgumentException(); // TODO G[bZ[W

            // vpeB
            if ( !isNestedPropertyName(nestedPropertyName) )
                throw new IllegalArgumentException(); // TODO G[bZ[W

        }

    }



    // Object̃\bh -------------------------------------------------------

    public boolean equals(Object obj) {
        return
            ValidatorUtil.equalOrNull(name, ((ObjectRef)obj).name)
            && ValidatorUtil.equalOrNull(nestedPropertyName, ((ObjectRef)obj).nestedPropertyName);
    }

    public int hashCode() {
        int hash = name.hashCode();

        if ( nestedPropertyName != null )
            hash ^= nestedPropertyName.hashCode();

        return hash;
    }

    public String toString() {
        if ( nestedPropertyName != null )
            return name + '.' + nestedPropertyName;
        else
            return name;
    }


    // vpeB -------------------------------------------------------------

    public String getNestedPropertyName() {
        return nestedPropertyName;
    }

    public String getName() {
        return name;
    }


    // X^eBbN\bh ---------------------------------------------------

    /**
     * 񂪃IuWFNg̎QƎȂtrueԂB
     * @param string
     * @return
     */
    public static boolean isNestedPropertyName(String string) {

        // ܂܂Ȃfalse

        if ( ValidatorUtil.isBlankOrNull(string) )
            return false;

        // vpeB

        String[] tokens = null;
        if ( string.indexOf('.') > -1 ) {
            tokens = string.split("\\.");
        }
        else {
            return isPropertyExpression(string);
        }

        for (int i = 0; i < tokens.length; i++) {
            if ( !isPropertyExpression(tokens[i]) )
                return false;
        }

        return true;

    }

    private static Pattern mappedOptionPattern = Pattern.compile("^\\(.+\\)$");
    private static Pattern indexedOptionPattern = Pattern.compile("^\\[[0-9]+\\]$");

    public static boolean isPropertyExpression(String str) {

        if ( ValidatorUtil.isBlankOrNull(str) )
            return false;

        int mappedIdx = str.indexOf("(");
        int indexedIdx = str.indexOf('[');

        String name = null;

        if ( mappedIdx > -1 ) {
            name = str.substring(0, mappedIdx);
            String opt = str.substring(mappedIdx+1);
            if ( !mappedOptionPattern.matcher(opt).matches() )
                return false;
        }

        else if ( indexedIdx > -1 ) {
            name = str.substring(0, indexedIdx);
            String opt = str.substring(indexedIdx+1);
            if ( !indexedOptionPattern.matcher(opt).matches() )
                return false;
        }

        else {
            name = str;
        }

        return JavaIdentifier.isJavaIdentifier(name);

    }


}
