/*
 * $Id: DataResponse.java,v 1.1 2006/05/15 07:02:34 sugimotokenichi Exp $
 * Copyright (C) 2004-2006 SUGIMOTO Ken-ichi
 * 쐬: 2006/05/15
 */
package feat2.impl;

import java.util.Map;

import feat2.ApplicationException;
import feat2.CommandContext;
import feat2.Data;
import feat2.Processor;
import feat2.Response;
import feat2.config.DataConfig;

/**
 * DATAX|X̎B
 * @author SUGIMOTO Ken-ichi
 */
public class DataResponse implements Response {

    private DataConfig config;
    private Data data;


    public DataResponse(Data data, DataConfig config) {
        this.data = data;
        this.config = config;
    }


    public String output(CommandContext ctx) throws ApplicationException {

        try {

            Map inputValues = Processor.processInputs(config, ctx);

            if ( Processor.processValidations(data, inputValues, config, ctx) ) {

                Processor.processInjection(data, inputValues);
                data.output(ctx);

            }

            else {

                return config.getErrorResponse().getValue();

            }

        }
        catch (Exception ex) {
            throw new ApplicationException(ex);
        }

        return null;

    }


}
