/*
 * $Revision: 1.1 $ $Date: 2006/04/11 16:14:32 $
 * (C) 2004 SUGIMOTO Ken-ichi
 * 쐬F 2004/08/27
 */

package feat2.template;

import org.w3c.dom.Node;


/**
 * HTML\m[h̃C^tF[XB
 */
public interface HTMLNode {

    public static final int
        NODETYPE_ELEMENT = Node.ELEMENT_NODE,
        NODETYPE_DOCUMENT = Node.DOCUMENT_NODE,
        NODETYPE_ATTRIBUTE = Node.ATTRIBUTE_NODE,
        NODETYPE_TEXT = Node.TEXT_NODE,
        NODETYPE_REMARK = Node.COMMENT_NODE;

    public HTMLNode getParent() throws NodeNotFoundException;

    public HTMLDocument getDocument() throws NodeNotFoundException;

    /**
     * qm[hԂBqm[hȂނ̃m[h̏ꍇ
     * NodeNotFoundExceptionX[B
     * @return
     * @throws NodeNotFoundException
     */
    public HTMLNode getFirstChild() throws NodeNotFoundException;

    /**
     * ̃m[hԂB
     * @return
     */
    public HTMLNode getNext() throws NodeNotFoundException;

    /**
     * Õm[hԂB
     * @return
     */
    public HTMLNode getPrev() throws NodeNotFoundException;

    /**
     * ŏ̌Zm[hԂB
     * @return
     */
    public HTMLNode getFirst();

    /**
     * Ō̌Zm[hԂB
     * @return
     */
    public HTMLNode getLast();

    /**
     * ̃m[h̒lԂB
     * m[hText, Remark, Attributȅꍇ͂ꂼ̃eLXglA
     * ȊÕm[hnullԂB
     * @return m[h̒l
     */
    public String getValue();

    /**
     * ̃m[ȟnode}B
     * nodenull̂Ƃ͉ȂB
     * @param node Vǉm[hBAXgɂȂĂĂǂB
     */
    public void insertAfter(HTMLNode node);

    /**
     * ̃m[h̑Onode}B
     * nodenull̂Ƃ͉ȂB
     * @param node Vǉm[hBAXgɂȂĂĂǂB
     */
    public void insertBefore(HTMLNode node);

    /**
     * m[hRs[B
     * ꂽm[h͐eȂBdeeptruȅꍇÃm[h擪ƂTuc[ŜRs[B
     * falsêƂ͂̃m[hRs[B
     * ̃m[hElementm[ĥƂAttributeRs[B
     * @param deep
     * @return
     */
    public HTMLNode copy(boolean deep);

    /**
     * ̃m[h(擪ƂTuc[)c[؂藣B
     */
    public void detach();

    /**
     * ̃m[h̎ނԂB
     * Ԃl͂̃C^tF[X̒`QƁB
     * @return
     */
    public int getNodeType();

    /**
     * ̃m[hHTMLɕϊB
     * HTML͂̃\bhĂяoxɐB
     * qm[hHTMLׂďo͂B
     * @return ͂ƓStringBuffer
     */
    public StringBuffer toHTML(StringBuffer buf);

}
