/*
 * $Id: DOMAttrImpl.java,v 1.1 2006/04/11 16:14:32 sugimotokenichi Exp $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 쐬: 2005/10/30
 */
package feat2.template.impl;

import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

import feat2.template.HTMLElement;
import feat2.template.HTMLNode;
import feat2.template.NodeNotFoundException;

/**
 * DOM APIAttr̎B
 * @author SUGIMOTO Ken-ichi
 */
public class DOMAttrImpl extends DOMNodeImpl implements Attr {

    DOMAttrImpl(HTMLValuedAttribute htmlNode) {
        super(htmlNode);
    }

    private HTMLValuedAttribute getHTMLAttribute() {
        return (HTMLValuedAttribute)convertHTML();
    }

    public short getNodeType() {
        return ATTRIBUTE_NODE;
    }

    public boolean hasAttributes() {
        return false;
    }

    public String getLocalName() {
        return this.getName();
    }

    public String getNodeName() {
        return this.getName();
    }

    public String getNodeValue() throws DOMException {
        return this.getValue();
    }

    public void setNodeValue(String nodeValue) throws DOMException {
        throw new DOMException(DOMException.NOT_SUPPORTED_ERR, "");
    }

    public NamedNodeMap getAttributes() {
        return new HTMLNodeMapImpl();
    }

    public NodeList getChildNodes() {
        return new HTMLNodeListImpl();
    }

    // Attr̎

    public String getName() {
        return getHTMLAttribute().getName();
    }

    public Element getOwnerElement() {
        try {
            HTMLNode parent = getHTMLAttribute().getParent();
            if ( parent instanceof HTMLElement ) {
                return (Element)TemplateUtil.toDomNode(parent);
            }
        }
        catch (NodeNotFoundException ex) {
        }
        return null;
    }

    public boolean getSpecified() {
        return false;
    }

    public String getValue() {
        return getHTMLAttribute().getValue();
    }

    public void setValue(String value) throws DOMException {
        throw new DOMException(DOMException.NOT_SUPPORTED_ERR, "");
    }

}
