/*
 * $Id: LengthValidator.java,v 1.1 2006/04/11 16:14:32 sugimotokenichi Exp $
 * Copyright (C) 2006 SUGIMOTO Ken-ichi
 * 쐬: 2006/03/09
 */
package feat2.validation;

import java.util.HashMap;
import java.util.Map;

/**
 * ͒ľ̕؁B
 * @author SUGIMOTO Ken-ichi
 */
public class LengthValidator implements SingleValueValidator {

    private Integer max;
    private Integer min;


    public boolean validate(String value) {

        if ( ValidatorUtil.isBlankOrNull(value) )
            return true;

        if ( min != null )
            if ( value.length() < min.intValue() )
                return false;

        if ( max != null )
            if ( value.length() > max.intValue() )
                return false;

        return true;

    }

    public String getDefaultMessageId() {
        if ( max == null )
            return "error.validation.minlength";
        else if ( min == null )
            return "error.validation.maxlength";

        return "error.validation.length";
    }

    public Map getKeyrowds() {
        HashMap ret = new HashMap();
        if ( min != null )
            ret.put("min", min.toString());
        if ( max != null )
            ret.put("max", max.toString());
        return ret;
    }


    // vpeB -------------------------------------------------------------

    public Integer getMax() {
        return max;
    }

    public void setMax(Integer max) {
        this.max = max;
    }

    public Integer getMin() {
        return min;
    }

    public void setMin(Integer min) {
        this.min = min;
    }


}
