/*
 * $Id: NumberRangeValidator.java,v 1.1 2006/04/11 16:14:32 sugimotokenichi Exp $
 * Copyright (C) 2006 SUGIMOTO Ken-ichi
 * 쐬: 2006/03/09
 */
package feat2.validation;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

/**
 * l͈̔͂̌؁B
 * @author SUGIMOTO Ken-ichi
 */
public class NumberRangeValidator implements SingleValueValidator {

    private BigDecimal max;
    private BigDecimal min;

    public boolean validate(String value) {

        if ( ValidatorUtil.isBlankOrNull(value) )
            return true;

        BigDecimal source;
        try {
            source = new BigDecimal( value );
        }
        catch (NumberFormatException ex) {
            return false;
        }

        if ( min != null )
            if ( source.compareTo(min) < 0 )
                return false;

        if ( max != null )
            if ( source.compareTo(max) > 0 )
                return false;

        return true;
    }



    // vpeB -------------------------------------------------------------

    public BigDecimal getMax() {
        return max;
    }
    public void setMax(BigDecimal max) {
        this.max = max;
    }

    public BigDecimal getMin() {
        return min;
    }
    public void setMin(BigDecimal min) {
        this.min = min;
    }



    public String getDefaultMessageId() {
        if ( max == null )
            return "error.validation.minrange";
        else if ( min == null )
            return "error.validation.maxrange";

        return "error.validation.range";
    }



    public Map getKeyrowds() {
        HashMap ret = new HashMap();
        if ( min != null )
            ret.put("min", min.toString());
        if ( max != null )
            ret.put("max", max.toString());
        return ret;
    }



}
