/*
 * $Id: StringValidator.java,v 1.2 2006/04/21 15:04:21 sugimotokenichi Exp $
 * Copyright (C) 2006 SUGIMOTO Ken-ichi
 * 쐬: 2006/03/09
 */
package feat2.validation;

import java.util.Map;

import feat2.StringUtil;

/**
 * ̌؁B
 * @author SUGIMOTO Ken-ichi
 */
public class StringValidator implements SingleValueValidator {

    public static final String
        ASCII = "ascii",
        NUMBER = "number",
        FULL_WIDTH_NUMBER = "full-width-number",
        ALPHABET = "alphabet",
        FULL_WIDTH_ALPHABET = "full-width-alphabet",
        HIRAGANA = "hiragana",
        KATAKANA = "katakana",
        HALF_WIDTH_KATAKANA = "half-width-katakana",
        WHITE_SPACE = "white-space";



    private String pattern;
    private String[] charRange;

    public StringValidator() {
    }

    public boolean validate(String value) {

        if ( ValidatorUtil.isBlankOrNull(value) )
            return true;

        // K\̌

        if ( pattern != null )
            if ( !value.matches(pattern) )
                return false;

        // ͈͂̌

        if ( charRange != null ) {

            StringBuffer range = new StringBuffer("^[");

            for(int i=0; i<charRange.length; i++) {

                String rangeName = charRange[i];

                if ( rangeName.equals(ASCII) )
                    range.append("\\x00-\\x7f");

                else if ( rangeName.equals(NUMBER) )
                    range.append("0-9");

                else if ( rangeName.equals(FULL_WIDTH_NUMBER) )
                    range.append("O-X");

                else if ( rangeName.equals(ALPHABET) )
                    range.append("a-zA-Z");

                else if ( rangeName.equals(FULL_WIDTH_ALPHABET) )
                    range.append("-`-y");

                else if ( rangeName.equals(HIRAGANA) )
                    // '' - 'U'
                    range.append("\\u3041-\\u309e");

                else if ( rangeName.equals(KATAKANA) )
                    // '@' - 'S'
                    range.append("\\u30a1-\\u30fe");

                else if ( rangeName.equals(HALF_WIDTH_KATAKANA) )
                    // '' - ''
                    range.append("\\uff65-\\uff9f");
                else if ( rangeName.equals(WHITE_SPACE) )
                    // whitespace
                    range.append("\\s@");

            }

            // Lȕ͈͂w肳Ă猟

            if ( range.length() >= 2 ) {

                range.append("]+$");
                if ( !value.matches(range.toString()) )
                    return false;

            }

        }

        return true;

    }

    public String getDefaultMessageId() {
        return "error.validation.string";
    }

    public Map getKeyrowds() {
        return null;
    }


    // vpeB -------------------------------------------------------------

    public String getPattern() {
        return pattern;
    }
    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String[] getCharRanges() {
        return charRange;
    }

    public void setCharRange(String charRange) {
        this.charRange = StringUtil.split(charRange);
    }


}
