/*
 * $Id: ValidatorUtil.java,v 1.1 2006/04/11 16:14:32 sugimotokenichi Exp $
 * Copyright (C) 2006 SUGIMOTO Ken-ichi
 * 쐬: 2006/03/09
 */
package feat2.validation;

import org.apache.commons.validator.GenericValidator;

/**
 * of[^̂߂̃[eBeBNXB
 * @author SUGIMOTO Ken-ichi
 */
public class ValidatorUtil {

    /**
     * ẑׂẴ\[Xlnull܂͋󂾂trueԂB
     * @param values
     * @return
     */
    public static boolean isBlankOrNull(String[] values) {

        if ( values == null )
            return true;

        boolean ret = true;

        for (int i = 0; i < values.length; i++) {
            ret = ( ret && GenericValidator.isBlankOrNull(values[i]) );
        }

        return ret;

    }

    public static boolean isBlankOrNull(String str) {
        return GenericValidator.isBlankOrNull(str);
    }

    /**
     * z̍ŏnׂĂɒlĂtrueB
     * @param values
     * @param n
     * @return
     */
    public static boolean isNotBlank(String[] values, int n) {

        if ( values == null || values.length == 0 )
            return false;

        boolean ret = true;

        if ( values.length < n )
            n = values.length;

        for (int i = 0; i < n; i++) {
            ret = ( ret && !GenericValidator.isBlankOrNull(values[i]) );
        }

        return ret;

    }


    public static boolean equalOrNull(Object a, Object b) {
        if ( a == null && b == null )
            return true;
        return a.equals(b);
    }

    /*public static void main(String[] args) {
        System.out.println(isJavaIdentifierPath("aaa.bbb.c_cc"));
    }*/

}
