/*
 * Decompiled with CFR 0.152.
 */
package feat2;

import feat2.ApplicationException;
import feat2.CommandContext;
import feat2.FeatErrors;
import feat2.FileUploadException;
import feat2.NotHandledException;
import feat2.ObjectUtil;
import feat2.PropertyAccessException;
import feat2.ResourceManager;
import feat2.Response;
import feat2.ResponseException;
import feat2.TemplateParsingException;
import feat2.ValidationError;
import feat2.config.ActionConfigBase;
import feat2.config.BeanConfig;
import feat2.config.ConfigurationException;
import feat2.config.DIComponentConfig;
import feat2.config.ExceptionConfig;
import feat2.config.InputConfigBase;
import feat2.config.InputLiteralConfig;
import feat2.config.InputObjectConfig;
import feat2.config.InputParamConfig;
import feat2.config.InputResourceConfig;
import feat2.config.ResponseConfigBase;
import feat2.config.ValidatableComponentConfig;
import feat2.config.ValidationConfig;
import feat2.config.type.Identifier;
import feat2.config.type.JavaIdentifier;
import feat2.config.type.ObjectRef;
import feat2.config.type.Scope;
import feat2.impl.Command;
import feat2.impl.RedirectResponse;
import feat2.validation.ArrayValueValidator;
import feat2.validation.ObjectValidator;
import feat2.validation.SingleValueValidator;
import feat2.validation.Validator;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

public class Processor {
    public void process(CommandContext ctx) throws ServletException, IOException, ResponseException {
        try {
            String scheme = ctx.getCurrentCommandConfig().getScheme();
            if (scheme != null && !scheme.equals(ctx.getRequest().getScheme())) {
                this.changeScheme(ctx);
                return;
            }
            String responseName = null;
            Command command = new Command(ctx.getCurrentCommandConfig());
            try {
                responseName = this.processCommand(command, ctx);
            }
            catch (ApplicationException ex) {
                responseName = this.processException(ctx, ex);
            }
            HashSet<String> responseHistory = new HashSet<String>();
            while (true) {
                ResponseException ex;
                if (responseName == null) {
                    ex = new ResponseException("exception.Processor.response.null");
                    ex.addKeyword("feature", ctx.getCurrentFeatureConfig().getName().getValue());
                    throw ex;
                }
                try {
                    if (responseHistory.contains(responseName)) {
                        ex = new ResponseException("exception.Processor.response.recursion");
                        ex.addKeyword("feature", ctx.getCurrentFeatureConfig().getName().getValue());
                        ex.addKeyword("response", responseName);
                        throw ex;
                    }
                    responseHistory.add(responseName);
                    String next = this.processResponse(responseName, ctx);
                    if (next == null) break;
                    responseName = next;
                }
                catch (ApplicationException ex2) {
                    responseName = this.processException(ctx, ex2);
                }
            }
            this.processRewrite(command, ctx);
        }
        catch (PropertyAccessException ex) {
            throw new ServletException((Throwable)ex);
        }
        catch (TemplateParsingException ex) {
            throw new ServletException((Throwable)ex);
        }
        catch (NotHandledException ex) {
            throw new ServletException(ex.getCause());
        }
        catch (FileUploadException ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    private String processCommand(Command com, CommandContext ctx) throws PropertyAccessException, ApplicationException, FileUploadException {
        return com.execute(ctx);
    }

    private String processResponse(String responseName, CommandContext ctx) throws IOException, PropertyAccessException, TemplateParsingException, ServletException, ApplicationException, FileUploadException {
        ResponseConfigBase responseConf = ctx.getCurrentFeatureConfig().getResponseConfig(responseName);
        Response res = responseConf.getResponseInstance();
        return res.output(ctx);
    }

    private String processException(CommandContext ctx, ApplicationException ex) throws NotHandledException {
        ctx.setException(ex.getCause());
        Class<?> exclass = ex.getCause().getClass();
        ExceptionConfig exceptionConf = ctx.getCurrentCommandConfig().getException(exclass);
        if (exceptionConf == null) {
            exceptionConf = ctx.getCurrentFeatureConfig().getException(exclass);
        }
        if (exceptionConf == null) {
            throw new NotHandledException(ex.getCause());
        }
        String ret = exceptionConf.getResponseName().getValue();
        return ret;
    }

    private void processRewrite(Command command, CommandContext ctx) {
        ActionConfigBase[] actions = command.getConfig().getActions();
        for (int i = 0; i < actions.length; ++i) {
            BeanConfig beanConf;
            Scope scope;
            if (!(actions[i] instanceof BeanConfig) || !(scope = (beanConf = (BeanConfig)actions[i]).getScope()).isSession()) continue;
            String beanName = beanConf.getName().getValue();
            Object obj = ctx.getAttribute(beanName);
            ctx.setAttribute(beanName, obj, scope);
        }
    }

    private void changeScheme(CommandContext ctx) throws IOException {
        try {
            HttpServletRequest request = ctx.getRequest();
            URI uri = new URI(request.getRequestURI());
            String scheme = ctx.getCurrentCommandConfig().getScheme();
            String method = request.getMethod().toLowerCase();
            String host = request.getServerName();
            int port = -1;
            if (scheme.equals("http")) {
                port = ctx.getFeatConfig().getHttpPort();
            } else if (scheme.equals("https")) {
                port = ctx.getFeatConfig().getHttpsPort();
            }
            URI newUri = new URI(scheme, uri.getRawUserInfo(), host, port, uri.getRawPath(), uri.getRawQuery(), null);
            if (method.equals("get")) {
                RedirectResponse.redirectGet(newUri.toString(), ctx.getRequestParameterMap(), ctx);
            } else if (method.equals("post")) {
                RedirectResponse.redirectPost(newUri.toString(), ctx.getRequestParameterMap(), ctx);
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new ConfigurationException(ex);
        }
        catch (URISyntaxException ex) {
            throw new ConfigurationException(ex);
        }
    }

    public static Map processInputs(DIComponentConfig config, CommandContext ctx) throws PropertyAccessException, FileUploadException, ConfigurationException {
        InputConfigBase[] inputs = config.getInputs();
        HashMap<String, String[]> ret = new HashMap<String, String[]>();
        HttpServletRequest req = ctx.getRequest();
        boolean isGetMethod = req.getMethod().equalsIgnoreCase("GET");
        String encoding = req.getCharacterEncoding();
        for (int i = 0; i < inputs.length; ++i) {
            Object inputValue = null;
            if (inputs[i] instanceof InputObjectConfig) {
                InputObjectConfig inputObjectConf = (InputObjectConfig)inputs[i];
                ObjectRef ref = inputObjectConf.getRef();
                Object target = null;
                Scope scope = inputObjectConf.getScope();
                if (scope == null) {
                    scope = new Scope("local");
                }
                if ((target = ctx.getAttribute(ref.getName(), scope)) != null) {
                    if (ref.getNestedPropertyName() != null) {
                        try {
                            inputValue = ObjectUtil.getProperty(target, ref.getNestedPropertyName());
                        }
                        catch (NoSuchMethodException ex) {
                            throw new PropertyAccessException(inputObjectConf.getConfigPath(), ex);
                        }
                        catch (InvocationTargetException ex) {
                            throw new PropertyAccessException(inputObjectConf.getConfigPath(), ex);
                        }
                        catch (IllegalAccessException ex) {
                            throw new PropertyAccessException(inputObjectConf.getConfigPath(), ex);
                        }
                    } else {
                        inputValue = target;
                    }
                }
            } else if (inputs[i] instanceof InputParamConfig) {
                InputParamConfig inputParamConf = (InputParamConfig)inputs[i];
                if (ctx.isMultipartRequest()) {
                    Map params = ctx.getMultipartRequestBody();
                    CommandContext.MultipartFormItem item = (CommandContext.MultipartFormItem)params.get(inputParamConf.getRef());
                    if (item != null) {
                        inputValue = item.isFormField() ? item.getString() : item;
                    }
                } else {
                    String[] values = ctx.getRequestParameterValues(inputParamConf.getRef());
                    if (values != null) {
                        inputValue = values.length == 1 ? values[0] : values;
                    }
                }
            } else if (inputs[i] instanceof InputLiteralConfig) {
                InputLiteralConfig inputLiteralConf = (InputLiteralConfig)inputs[i];
                inputValue = inputLiteralConf.getValue();
            } else if (inputs[i] instanceof InputResourceConfig) {
                InputResourceConfig inputResourceConf = (InputResourceConfig)inputs[i];
                inputValue = ctx.getStringResource(inputResourceConf.getRef());
            }
            String propName = inputs[i].getPropertyName().getValue();
            ret.put(propName, (String[])inputValue);
        }
        return ret;
    }

    public static boolean processValidations(Object bean, Map inputValues, ValidatableComponentConfig config, CommandContext ctx) throws PropertyAccessException, FileUploadException {
        boolean ret = true;
        ValidationConfig[] validations = config.getValidations();
        HashMap<Identifier, String> results = new HashMap<Identifier, String>();
        FeatErrors errs = ctx.getFeatErrors();
        for (int i = 0; i < validations.length; ++i) {
            ValidationError err;
            int j;
            Object[] values;
            ValidationConfig validationConfig = validations[i];
            Validator validator = validationConfig.getValidatorInstance();
            Map validatorParams = Processor.processInputs(validationConfig, ctx);
            Processor.processInjection(validator, validatorParams);
            boolean valid = true;
            ValidationConfig[] depends = validationConfig.getDepends();
            for (int j2 = 0; j2 < depends.length; ++j2) {
                if (results.get(depends[j2].getName()) != null) continue;
                valid = false;
                break;
            }
            JavaIdentifier[] propertyNames = validationConfig.getProperties();
            if (!valid) continue;
            String messageId = validationConfig.getMessageId();
            if (messageId == null) {
                messageId = validator.getDefaultMessageId();
            }
            if (validator instanceof ArrayValueValidator) {
                values = Processor.getPropertyValues(bean, inputValues, propertyNames);
                if (((ArrayValueValidator)validator).validate((String[])values)) {
                    results.put(validationConfig.getName(), "valid");
                    continue;
                }
                ValidationError err2 = new ValidationError(messageId, validationConfig);
                Processor.addKeywords(validator, err2);
                err2.addKeyrowd("property", Processor.getPropertyDisplayName(propertyNames, config, errs.getResourceManager()));
                errs.add(err2);
                ret = false;
                continue;
            }
            if (validator instanceof SingleValueValidator) {
                values = Processor.getPropertyValues(bean, inputValues, propertyNames);
                int passCount = 0;
                for (j = 0; j < values.length; ++j) {
                    if (((SingleValueValidator)validator).validate((String)values[j])) {
                        ++passCount;
                        continue;
                    }
                    err = new ValidationError(messageId, validationConfig);
                    Processor.addKeywords(validator, err);
                    err.addKeyrowd("property", Processor.getPropertyDisplayName(propertyNames[j], config, errs.getResourceManager()));
                    errs.add(err);
                }
                if (passCount == values.length) {
                    results.put(validationConfig.getName(), "valid");
                    continue;
                }
                ret = false;
                continue;
            }
            if (!(validator instanceof ObjectValidator)) continue;
            values = Processor.getPropertyObjects(bean, inputValues, propertyNames);
            int passCount = 0;
            for (j = 0; j < values.length; ++j) {
                if (((ObjectValidator)validator).validate(values[j])) {
                    ++passCount;
                    continue;
                }
                err = new ValidationError(messageId, validationConfig);
                Processor.addKeywords(validator, err);
                err.addKeyrowd("property", Processor.getPropertyDisplayName(propertyNames[j], config, errs.getResourceManager()));
                errs.add(err);
            }
            if (passCount == values.length) {
                results.put(validationConfig.getName(), "valid");
                continue;
            }
            ret = false;
        }
        return ret;
    }

    private static String[] getPropertyValues(Object bean, Map inputValues, JavaIdentifier[] propertyNames) throws PropertyAccessException {
        Object[] objects = Processor.getPropertyObjects(bean, inputValues, propertyNames);
        ArrayList<Object> strings = new ArrayList<Object>();
        for (int i = 0; i < propertyNames.length; ++i) {
            if (objects[i] instanceof String[]) {
                String[] array = (String[])objects[i];
                for (int j = 0; j < array.length; ++j) {
                    strings.add(array[j]);
                }
                continue;
            }
            if (objects[i] instanceof String) {
                strings.add(objects[i]);
                continue;
            }
            strings.add(objects[i].toString());
        }
        return strings.toArray(new String[0]);
    }

    private static Object[] getPropertyObjects(Object bean, Map inputValues, JavaIdentifier[] propertyNames) throws PropertyAccessException {
        Object[] values = new Object[propertyNames.length];
        for (int i = 0; i < propertyNames.length; ++i) {
            String propertyName = propertyNames[i].getValue();
            try {
                Object v = inputValues.get(propertyName);
                if (v == null) {
                    v = ObjectUtil.getProperty(bean, propertyName);
                }
                values[i] = v;
                continue;
            }
            catch (NoSuchMethodException ex) {
                throw new PropertyAccessException(ex);
            }
            catch (InvocationTargetException ex) {
                throw new PropertyAccessException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new PropertyAccessException(ex);
            }
        }
        return values;
    }

    private static String getPropertyDisplayName(JavaIdentifier propertyName, ValidatableComponentConfig config, ResourceManager rm) {
        String resourceId = config.getPropertyNameId(propertyName.getValue());
        String ret = null;
        if (resourceId != null && (ret = rm.getStringResource(resourceId)) == null) {
            ret = resourceId;
        }
        if (ret == null) {
            ret = propertyName.getValue();
        }
        return ret;
    }

    private static String getPropertyDisplayName(JavaIdentifier[] propertyNames, ValidatableComponentConfig config, ResourceManager rm) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < propertyNames.length; ++i) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(Processor.getPropertyDisplayName(propertyNames[i], config, rm));
        }
        return buf.toString();
    }

    private static void addKeywords(Validator validator, ValidationError err) {
        Map kw = validator.getKeyrowds();
        if (kw != null) {
            Iterator iter = kw.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                err.addKeyrowd(key, (String)kw.get(key));
            }
        }
    }

    public static void processInjection(Object bean, Map inputValues) throws PropertyAccessException {
        try {
            ObjectUtil.populate(bean, inputValues);
        }
        catch (IllegalAccessException ex) {
            throw new PropertyAccessException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new PropertyAccessException(ex);
        }
    }
}

