/*
 * Decompiled with CFR 0.152.
 */
package feat2.config;

import feat2.Action;
import feat2.FeatErrors;
import feat2.config.Config;
import feat2.config.ConfigError;
import feat2.config.ConfigUtil;
import feat2.config.DIComponentConfig;
import feat2.config.InputConfigBase;
import feat2.config.InputSupport;
import feat2.config.ValidatableComponentConfig;
import feat2.config.ValidationConfig;
import feat2.config.ValidationSupport;
import feat2.config.type.Identifier;
import feat2.config.type.JavaIdentifier;

public abstract class ActionConfigBase
extends Config
implements DIComponentConfig,
ValidatableComponentConfig {
    private Identifier name;
    private JavaIdentifier className;
    private InputSupport inputs = new InputSupport(this);
    private ValidationSupport validations = new ValidationSupport(this);
    private Class actionClass;
    private Identifier errorResponse;

    public Identifier getName() {
        return this.name;
    }

    public void setName(Identifier name) {
        this.name = name;
    }

    public JavaIdentifier getClassName() {
        return this.className;
    }

    public void setClassName(JavaIdentifier className) {
        this.className = className;
    }

    public Identifier getErrorResponse() {
        return this.errorResponse;
    }

    public void setErrorResponse(Identifier errorResponse) {
        this.errorResponse = errorResponse;
    }

    protected Class getActionClass() {
        return this.actionClass;
    }

    public abstract Action getActionInstance();

    public void addInput(InputConfigBase input) {
        this.inputs.addInput(input);
    }

    public InputConfigBase[] getInputs() {
        return this.inputs.getInputs();
    }

    public InputConfigBase getInputConfig(String propertyName) {
        return this.inputs.getInputConfig(propertyName);
    }

    public void addValidation(ValidationConfig validation) {
        this.validations.addValidation(validation);
    }

    public ValidationConfig[] getValidations() {
        return this.validations.getValidations();
    }

    public ValidationConfig getValidationConfig(String name) {
        return this.validations.getValidationConfig(name);
    }

    public String getPropertyNameId(String propertyName) {
        return this.inputs.getInputConfig(propertyName).getDisplayName();
    }

    public boolean validate(FeatErrors errs) {
        boolean ret = true;
        ret = ret && ConfigUtil.validateRequired(this.name, "name", this, errs);
        this.actionClass = ConfigUtil.validateClass(this.className, "class", this, errs);
        if (this.actionClass == null) {
            ret = false;
        }
        if (this.validations.count() > 0) {
            if (this.errorResponse == null) {
                errs.add(new ConfigError(null, "error-response", "error_response", 10, this));
            } else {
                String responseName = this.errorResponse.getValue();
                if (this.getFeatureConfig().getResponseConfig(responseName) == null) {
                    errs.add(new ConfigError(responseName, "error-response", "referrence.response", 10, this));
                }
            }
        }
        ret = ret && this.inputs.validate(errs);
        ret = ret && this.validations.validate(errs);
        return ret;
    }
}

