/*
 * Decompiled with CFR 0.152.
 */
package feat2.config;

import feat2.Action;
import feat2.CommandContext;
import feat2.FeatErrors;
import feat2.FeatRuntimeException;
import feat2.HTTPSessionException;
import feat2.config.ActionConfigBase;
import feat2.config.type.Scope;

public class BeanConfig
extends ActionConfigBase {
    private Scope scope;

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public String getElementName() {
        return "bean";
    }

    public Action getActionInstance() {
        return new BeanAction(this.getActionClass(), this.getName().getValue());
    }

    public boolean validate(FeatErrors errs) {
        boolean ret = super.validate(errs);
        if (this.scope == null) {
            this.scope = new Scope("local");
        }
        return ret;
    }

    public class BeanAction
    implements Action {
        private Class beanClass;
        private String beanName;
        private Object bean;

        private BeanAction(Class beanClass, String beanName) {
            this.beanClass = beanClass;
            this.beanName = beanName;
        }

        public Object execute(CommandContext ctx) {
            return this.bean;
        }

        public Object getBean(CommandContext ctx) throws HTTPSessionException {
            this.bean = ctx.getAttribute(this.beanName, BeanConfig.this.scope);
            if (this.bean == null) {
                this.bean = this.createBeanInstance();
                ctx.setAttribute(this.beanName, this.bean, BeanConfig.this.scope);
            }
            return this.bean;
        }

        private Object createBeanInstance() {
            try {
                return this.beanClass.newInstance();
            }
            catch (InstantiationException ex) {
                throw new FeatRuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new FeatRuntimeException(ex);
            }
        }
    }
}

