/*
 * Decompiled with CFR 0.152.
 */
package feat2.config;

import feat2.Util;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class Resources {
    private Map resourceMap = new HashMap();

    public void addResource(String name, Locale lang, String value) {
        ResourceKey key = new ResourceKey(name, lang);
        this.resourceMap.put(key, value);
    }

    public synchronized void addResources(Resources resources) {
        this.resourceMap.putAll(resources.resourceMap);
    }

    public String getString(String name, Locale lang) {
        String ret = (String)this.resourceMap.get(new ResourceKey(name, lang));
        return ret;
    }

    public boolean exists(String name) {
        Set keys = this.resourceMap.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            ResourceKey element = (ResourceKey)iter.next();
            if (!element.name.equals(name)) continue;
            return true;
        }
        return false;
    }

    private class ResourceKey {
        String name;
        Locale lang;
        int hash;

        ResourceKey(String name, Locale lang) {
            this.name = name;
            this.lang = lang == null ? Util.NULL_LOCALE : lang;
            this.hash = -1;
        }

        public boolean equals(Object o) {
            ResourceKey k = (ResourceKey)o;
            return this.name.equals(k.name) && this.lang.equals(k.lang);
        }

        public int hashCode() {
            if (this.hash == -1) {
                this.hash = this.name.hashCode() ^ this.lang.hashCode();
            }
            return this.hash;
        }
    }
}

