/*
 * Decompiled with CFR 0.152.
 */
package feat2.config;

import feat2.FeatErrors;
import feat2.config.Config;
import feat2.config.ConfigUtil;
import feat2.config.ConfigurationException;
import feat2.config.Dependencies;
import feat2.config.ValidatableComponentConfig;
import feat2.config.ValidationConfig;
import feat2.config.type.Identifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ValidationSupport
implements ValidatableComponentConfig {
    private Config parent;
    private ArrayList validations;
    private boolean sorted;

    public ValidationSupport(Config parent) {
        this.parent = parent;
        this.validations = new ArrayList();
        this.sorted = false;
    }

    public void addValidation(ValidationConfig validation) {
        this.validations.add(validation);
        validation.setParent(this.parent);
        this.sorted = false;
    }

    public ValidationConfig[] getValidations() throws ConfigurationException {
        if (!this.sorted) {
            this.validations = this.sortValidation(this.validations);
            this.sorted = true;
        }
        return this.validations.toArray(new ValidationConfig[0]);
    }

    public ValidationConfig getValidationConfig(String name) {
        Iterator iter = this.validations.iterator();
        while (iter.hasNext()) {
            ValidationConfig cfg = (ValidationConfig)iter.next();
            if (!cfg.getName().getValue().equals(name)) continue;
            return cfg;
        }
        return null;
    }

    public int count() {
        return this.validations.size();
    }

    public boolean validate(FeatErrors errs) {
        return ConfigUtil.validate(this.validations.iterator(), errs);
    }

    private ArrayList sortValidation(List validations) throws ConfigurationException {
        ArrayList<Object> ret = new ArrayList<Object>();
        Dependencies dep = new Dependencies();
        for (int i = 0; i < validations.size(); ++i) {
            ValidationConfig config = (ValidationConfig)validations.get(i);
            dep.addDependency(config, null);
            ValidationConfig[] depends = config.getDepends();
            for (int ii = 0; ii < depends.length; ++ii) {
                dep.addDependency(config, depends[ii]);
            }
        }
        while (dep.count() > 0) {
            Object o = dep.getIndependentObject();
            if (o == null) {
                throw new ConfigurationException("error.config.ValidationConfig.recurrence");
            }
            dep.removeDependencies(o);
            ret.add(o);
        }
        return ret;
    }

    public String getPropertyNameId(String propertyName) {
        return null;
    }

    public Identifier getErrorResponse() {
        return null;
    }
}

