/*
 * Decompiled with CFR 0.152.
 */
package feat2.impl;

import org.apache.commons.lang.StringUtils;

public class StringReplacer {
    private String[] searchStrs;
    private char[][] replaceStrs;
    private long searchHash;
    private static final int LOOP = 1000000;

    public StringReplacer(String[] searchStrs, String[] replaceStrs) {
        this.searchStrs = searchStrs;
        this.replaceStrs = new char[replaceStrs.length][];
        for (int i = 0; i < replaceStrs.length; ++i) {
            this.replaceStrs[i] = replaceStrs[i].toCharArray();
        }
        this.searchHash = this.getStringArrayHash(searchStrs);
    }

    public StringReplacer(String searchChars, String replaceChars) {
        this.searchStrs = new String[searchChars.length()];
        this.replaceStrs = new char[searchChars.length()][];
        for (int i = 0; i < searchChars.length(); ++i) {
            this.searchStrs[i] = Character.toString(searchChars.charAt(i));
            this.replaceStrs[i] = new char[]{replaceChars.charAt(i)};
        }
        this.searchHash = this.getStringArrayHash(this.searchStrs);
    }

    public String replace(String str) {
        char[] o = new char[str.length() * 12 / 10];
        int count = 0;
        int strlen = str.length();
        int oidx = 0;
        int i = 0;
        while (i < strlen) {
            char c = str.charAt(i);
            long hash = 1L << c % 64;
            if ((hash & this.searchHash) != 0L) {
                int replaceIdx = -1;
                for (int j = 0; j < this.searchStrs.length; ++j) {
                    if (this.searchStrs[j].length() == 1) {
                        if (this.searchStrs[j].charAt(0) != c) continue;
                        replaceIdx = j;
                        break;
                    }
                    if (!str.regionMatches(i, this.searchStrs[j], 0, this.searchStrs[j].length())) continue;
                    replaceIdx = j;
                    break;
                }
                if (replaceIdx > -1) {
                    this.copy(this.replaceStrs[replaceIdx], 0, o, oidx, this.replaceStrs[replaceIdx].length);
                    oidx += this.replaceStrs[replaceIdx].length;
                    i += this.searchStrs[replaceIdx].length();
                    ++count;
                    continue;
                }
                o[oidx++] = c;
                ++i;
                continue;
            }
            o[oidx++] = c;
            ++i;
        }
        if (count > 0) {
            return new String(o, 0, oidx);
        }
        return str;
    }

    private char[] copy(char[] src, int srcOffset, char[] dest, int destOffset, int len) {
        if (destOffset + len > dest.length) {
            char[] newDest = new char[dest.length * 12 / 10 + len];
            System.arraycopy(dest, 0, newDest, 0, dest.length);
            dest = newDest;
        }
        System.arraycopy(src, srcOffset, dest, destOffset, len);
        return dest;
    }

    private long getStringArrayHash(String[] a) {
        long ret = 0L;
        for (int i = 0; i < a.length; ++i) {
            ret |= 1L << a[i].charAt(0) % 64;
        }
        return ret;
    }

    public static void main(String[] args) {
        int i;
        String str = "--012-----------GHI---------ABCDEF-----56789----------3345---XYXYXYXYX-----------------";
        String[] test = str.split("");
        String[] search = new String[]{"012", "345", "678", "ABC", "DEF", "GHI", "XYX", "x"};
        String[] replace = new String[]{"{012}", "{345}", "{678}", "a", "d", "g", "x", "?"};
        StringReplacer rep = new StringReplacer(search, replace);
        String result = null;
        long start = System.currentTimeMillis();
        for (int i2 = 0; i2 < 1000000; ++i2) {
            result = rep.replace(str);
        }
        double t = (double)(System.currentTimeMillis() - start) / 1000000.0;
        System.out.println(result);
        System.out.println("StringReplacer:" + t);
        start = System.currentTimeMillis();
        for (int i3 = 0; i3 < 1000000; ++i3) {
            result = str;
            for (int j = 0; j < search.length; ++j) {
                result = StringUtils.replace((String)result, (String)search[j], (String)replace[j]);
            }
        }
        t = (double)(System.currentTimeMillis() - start) / 1000000.0;
        System.out.println(result);
        System.out.println("StringUtils.replace():" + t);
        String searchChars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        String replacechars = "..........abcdefghijklmnopqrstuvwxyz";
        rep = new StringReplacer(searchChars, replacechars);
        result = null;
        start = System.currentTimeMillis();
        for (i = 0; i < 1000000; ++i) {
            result = rep.replace(str);
        }
        t = (double)(System.currentTimeMillis() - start) / 1000000.0;
        System.out.println(result);
        System.out.println("StringReplacer(chars):" + t);
        result = null;
        start = System.currentTimeMillis();
        for (i = 0; i < 1000000; ++i) {
            result = StringUtils.replaceChars((String)str, (String)searchChars, (String)replacechars);
        }
        t = (double)(System.currentTimeMillis() - start) / 1000000.0;
        System.out.println(result);
        System.out.println("StringUtils.replaceChars():" + t);
    }
}

