/*
 * Decompiled with CFR 0.152.
 */
package feat2.template.form;

import feat2.template.HTMLElement;
import feat2.template.NodeFactory;
import feat2.template.form.ListItem;

public class Option
implements ListItem {
    private HTMLElement element;

    public Option(String name, String value) {
        this.element = NodeFactory.createHTMLElement("option", true);
        this.element.setText(name);
        this.element.setAttribute("value", value);
    }

    public Option(HTMLElement element) {
        this.element = element;
    }

    public String getLabel() {
        return this.element.getAttribute("label");
    }

    public void setLabel(String label) {
        if (label == null) {
            this.element.removeAttribute("label");
        } else {
            this.element.setAttribute("label", label);
        }
    }

    public String getValue() {
        String value = this.element.getAttribute("value");
        if (value == null) {
            return this.getContent();
        }
        return value;
    }

    public void setValue(String value) {
        if (value == null) {
            this.element.removeAttribute("value");
        } else {
            this.element.setAttribute("value", value);
        }
    }

    public boolean isSelected() {
        return this.element.hasAttribute("selected");
    }

    public void setSelected(boolean selected) {
        if (selected) {
            this.element.setAttribute("selected", null);
        } else {
            this.element.removeAttribute("selected");
        }
    }

    public String getContent() {
        return this.element.getString();
    }

    public void setContent(String value) {
        this.element.setText(value);
    }

    public HTMLElement getElement() {
        return this.element;
    }
}

