/*
 * Decompiled with CFR 0.152.
 */
package feat2.template.impl;

import feat2.template.HTMLNode;
import feat2.template.NodeListIterator;
import feat2.template.NodeNotFoundException;
import feat2.template.impl.HTMLCompositeNodeImpl;
import feat2.template.impl.HTMLConvertibleNode;
import feat2.template.impl.HTMLNodeImpl;
import feat2.template.impl.HTMLNodeListImpl;
import feat2.template.impl.TemplateUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class DOMNodeImpl
implements Node,
HTMLConvertibleNode {
    private HTMLNodeImpl htmlNode;

    DOMNodeImpl(HTMLNodeImpl htmlNode) {
        this.htmlNode = htmlNode;
    }

    public HTMLNode convertHTML() {
        return this.htmlNode;
    }

    public void normalize() {
    }

    public boolean hasChildNodes() {
        return this.getFirstChild() != null;
    }

    public String getNamespaceURI() {
        return null;
    }

    public String getPrefix() {
        return null;
    }

    public void setPrefix(String prefix) throws DOMException {
    }

    public Document getOwnerDocument() {
        try {
            return (Document)TemplateUtil.toDomNode(this.htmlNode.getDocument());
        }
        catch (NodeNotFoundException ex) {
            return null;
        }
    }

    public Node getFirstChild() {
        if (this.htmlNode instanceof HTMLCompositeNodeImpl) {
            return TemplateUtil.toDomNode(((HTMLCompositeNodeImpl)this.htmlNode).firstChild);
        }
        return null;
    }

    public Node getLastChild() {
        if (this.htmlNode instanceof HTMLCompositeNodeImpl) {
            HTMLCompositeNodeImpl cnode = (HTMLCompositeNodeImpl)this.htmlNode;
            if (cnode.firstChild != null) {
                return TemplateUtil.toDomNode(cnode.firstChild.getLast());
            }
        }
        return null;
    }

    public Node getNextSibling() {
        return TemplateUtil.toDomNode(this.htmlNode.next);
    }

    public Node getParentNode() {
        return TemplateUtil.toDomNode(this.htmlNode.parent);
    }

    public Node getPreviousSibling() {
        return TemplateUtil.toDomNode(this.htmlNode.prev);
    }

    public Node cloneNode(boolean deep) {
        return TemplateUtil.toDomNode(this.htmlNode.copy(deep));
    }

    public NodeList getChildNodes() {
        HTMLNodeListImpl ret = new HTMLNodeListImpl();
        try {
            NodeListIterator it = new NodeListIterator(this.htmlNode.getFirstChild());
            while (it.hasNext()) {
                ret.add(it.nextNode());
            }
        }
        catch (NodeNotFoundException nodeNotFoundException) {
            // empty catch block
        }
        return ret;
    }

    public boolean isSupported(String feature, String version) {
        return false;
    }

    public Node appendChild(Node newChild) throws DOMException {
        throw new DOMException(9, "");
    }

    public Node removeChild(Node oldChild) throws DOMException {
        throw new DOMException(9, "");
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        throw new DOMException(9, "");
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        throw new DOMException(9, "");
    }
}

