/*
 * Decompiled with CFR 0.152.
 */
package feat2.template.impl;

import feat2.StringUtil;
import feat2.template.HTMLAttribute;
import feat2.template.HTMLDocument;
import feat2.template.HTMLElement;
import feat2.template.HTMLNode;
import feat2.template.HTMLNodeList;
import feat2.template.NodeListIterator;
import feat2.template.NodeNotFoundException;
import feat2.template.impl.DOMDocumentImpl;
import feat2.template.impl.DOMElementImpl;
import feat2.template.impl.HTMLCompositeNodeImpl;
import feat2.template.impl.HTMLConvertibleNode;
import feat2.template.impl.HTMLNodeImpl;
import feat2.template.impl.HTMLNodeListImpl;
import feat2.template.impl.HTMLNodeMapImpl;
import feat2.template.impl.HTMLValuedAttribute;
import feat2.template.impl.HTMLWhitespaceAttribute;
import feat2.template.impl.TemplateUtil;
import java.util.List;
import org.apache.commons.jxpath.JXPathContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class HTMLElementImpl
extends HTMLCompositeNodeImpl
implements HTMLElement,
HTMLDocument {
    private HTMLAttribute firstAttribute;
    private String tagName;
    private String id;
    private String[] classList;
    private String encoding;
    private boolean startTag;
    private boolean endTag;

    HTMLElementImpl(boolean isDocumentNode) {
        this(null, true, true, isDocumentNode);
    }

    HTMLElementImpl(String tagName, boolean startTag, boolean endTag, boolean isDocumentNode) {
        this.tagName = tagName;
        this.startTag = startTag;
        this.endTag = endTag;
        if (isDocumentNode) {
            this.setDomNode(new DOMDocumentImpl(this));
        } else {
            this.setDomNode(new DOMElementImpl(this));
        }
    }

    public boolean isDocumentNode() {
        return this.getDomNode() instanceof Document;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    void addAttribute(HTMLAttribute attr, boolean withWhitespace) {
        HTMLAttribute last;
        if (attr == null) {
            return;
        }
        HTMLAttribute hTMLAttribute = last = this.firstAttribute != null ? (HTMLAttribute)this.firstAttribute.getLast() : null;
        if (attr instanceof HTMLValuedAttribute) {
            if (last == null) {
                HTMLWhitespaceAttribute firstSpace = new HTMLWhitespaceAttribute(" ");
                this.firstAttribute = firstSpace;
                firstSpace.setParent(this);
                last = firstSpace;
            } else if (withWhitespace && !(last instanceof HTMLWhitespaceAttribute)) {
                HTMLWhitespaceAttribute spaceNode = new HTMLWhitespaceAttribute(" ");
                last.insertAfter(spaceNode);
                last = spaceNode;
            }
            last.insertAfter(attr);
            HTMLValuedAttribute vattr = (HTMLValuedAttribute)attr;
            String name = vattr.getName();
            if (name != null) {
                if ((name = name.toLowerCase()).equals("id")) {
                    this.id = vattr.getValue();
                } else if (name.equals("class")) {
                    this.setClassList(vattr.getValue());
                }
            }
        } else if (attr instanceof HTMLWhitespaceAttribute) {
            if (last == null) {
                this.firstAttribute = attr;
                ((HTMLNodeImpl)((Object)attr)).setParent(this);
            } else if (last instanceof HTMLWhitespaceAttribute) {
                ((HTMLWhitespaceAttribute)last).addText(attr.getValue());
            } else {
                last.insertAfter(attr);
            }
        } else {
            last.insertAfter(attr);
        }
    }

    public boolean hasStartTag() {
        return this.startTag;
    }

    void assemble() {
        if (this.firstAttribute != null) {
            HTMLAttribute attrList = (HTMLAttribute)this.detachAll(this.firstAttribute);
            this.firstAttribute = null;
            if (attrList instanceof HTMLWhitespaceAttribute) {
                HTMLAttribute wsNode = attrList;
                attrList = (HTMLAttribute)((Object)((HTMLNodeImpl)((Object)attrList)).next);
                wsNode.detach();
                if (attrList == null) {
                    return;
                }
            }
            StringBuffer buf = TemplateUtil.nodeListToHTML(attrList, new StringBuffer());
            HTMLValuedAttribute a = new HTMLValuedAttribute(null, buf.toString());
            a.setQuote(null);
            this.addAttribute(a, false);
        }
    }

    HTMLNodeMapImpl getAttributes() {
        HTMLNodeMapImpl ret = new HTMLNodeMapImpl();
        NodeListIterator it = new NodeListIterator(this.firstAttribute);
        while (it.hasNext()) {
            HTMLValuedAttribute attr;
            HTMLNode node = it.nextNode();
            if (!(node instanceof HTMLValuedAttribute) || (attr = (HTMLValuedAttribute)node).getName() == null) continue;
            ret.put(attr.getName().toLowerCase(), attr);
        }
        return ret;
    }

    public String toString() {
        return this.startTagToString(new StringBuffer()).toString();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public HTMLNode find(String xpath) throws NodeNotFoundException {
        Node domNode = this.getDomNode();
        JXPathContext context = JXPathContext.newContext((Object)domNode);
        context.setLenient(true);
        Node found = (Node)context.selectSingleNode(xpath);
        HTMLNode ret = null;
        if (found instanceof HTMLConvertibleNode) {
            ret = ((HTMLConvertibleNode)((Object)found)).convertHTML();
        }
        if (ret == null) {
            throw new NodeNotFoundException("xpath:" + xpath);
        }
        return ret;
    }

    public HTMLNodeList select(String xpath) {
        Node domNode = this.getDomNode();
        if (domNode == null) {
            return null;
        }
        JXPathContext context = JXPathContext.newContext((Object)domNode);
        context.setLenient(true);
        List list = context.selectNodes(xpath);
        HTMLNodeListImpl ret = new HTMLNodeListImpl();
        for (int i = 0; i < list.size(); ++i) {
            ret.add(((HTMLConvertibleNode)list.get(i)).convertHTML());
        }
        return ret;
    }

    public String toHTML() {
        StringBuffer buf = new StringBuffer();
        this.toHTML(buf);
        return buf.toString();
    }

    public String getAttribute(String name) {
        String nameL = name.toLowerCase();
        if (nameL.equals("id")) {
            return this.id;
        }
        HTMLValuedAttribute attr = this.getValuedAttribute(name);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    public boolean containsClassValue(String classValue) {
        if (this.classList != null) {
            for (int i = 0; i < this.classList.length; ++i) {
                if (!this.classList[i].equals(classValue)) continue;
                return true;
            }
        }
        return false;
    }

    HTMLValuedAttribute getValuedAttribute(String name) {
        NodeListIterator it = new NodeListIterator(this.firstAttribute);
        while (it.hasNext()) {
            HTMLValuedAttribute attr;
            Object a = it.next();
            if (!(a instanceof HTMLValuedAttribute) || !(attr = (HTMLValuedAttribute)a).getName().equalsIgnoreCase(name)) continue;
            return attr;
        }
        return null;
    }

    public void setAttribute(String name, String value) {
        String nameL = name.toLowerCase();
        if (nameL.equals("id")) {
            this.id = value;
        } else if (nameL.equals("class")) {
            this.setClassList(value);
        }
        HTMLValuedAttribute attr = this.getValuedAttribute(name);
        if (attr == null) {
            attr = new HTMLValuedAttribute(name, null);
            this.addAttribute(attr, true);
        }
        attr.setValue(value);
    }

    private void setClassList(String classValue) {
        this.classList = StringUtil.split(classValue);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.setAttribute("id", id);
    }

    public String[] getClassList() {
        return this.classList;
    }

    public void setClassValue(String classValue) {
        this.setAttribute("class", classValue);
    }

    public boolean hasAttribute() {
        NodeListIterator it = new NodeListIterator(this.firstAttribute);
        while (it.hasNext()) {
            Object a = it.next();
            if (!(a instanceof HTMLValuedAttribute)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttribute(String name) {
        HTMLValuedAttribute attr = this.getValuedAttribute(name);
        return attr != null;
    }

    public void removeAttribute(String name) {
        String nameL = name.toLowerCase();
        if (nameL.equals("id")) {
            this.id = null;
        } else if (nameL.equals("class")) {
            this.classList = null;
        }
        HTMLValuedAttribute attr = this.getValuedAttribute(name);
        if (attr != null) {
            attr.setParent(null);
            if (attr == this.firstAttribute) {
                this.firstAttribute = (HTMLAttribute)((Object)attr.next);
            }
            attr.detach();
        }
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String name) {
        this.tagName = name;
    }

    public boolean hasEndTag() {
        return this.endTag;
    }

    public void setEndTag(boolean v) {
        this.endTag = v;
    }

    public String getValue() {
        return null;
    }

    public HTMLNode copy(boolean deep) {
        HTMLElementImpl ret = new HTMLElementImpl(this.isDocumentNode());
        ret.tagName = this.tagName;
        ret.id = this.id;
        if (this.classList != null) {
            ret.classList = (String[])this.classList.clone();
        }
        ret.startTag = this.startTag;
        ret.endTag = this.endTag;
        ret.encoding = this.encoding;
        if (this.firstAttribute != null) {
            ret.firstAttribute = (HTMLAttribute)TemplateUtil.copyNodeList((HTMLNodeImpl)((Object)this.firstAttribute), ret);
        }
        if (deep) {
            ret.setFirstChild(TemplateUtil.copyNodeList(this.firstChild, ret));
        }
        return ret;
    }

    public StringBuffer toHTML(StringBuffer buf) {
        this.startTagToString(buf);
        TemplateUtil.nodeListToHTML(this.firstChild, buf);
        this.endTagToString(buf);
        return buf;
    }

    private StringBuffer startTagToString(StringBuffer buf) {
        if (this.tagName != null && this.startTag) {
            buf.append("<").append(this.tagName);
            TemplateUtil.nodeListToHTML(this.firstAttribute, buf);
            buf.append(">");
        }
        return buf;
    }

    private StringBuffer endTagToString(StringBuffer buf) {
        if ((this.endTag || this.firstChild != null) && this.tagName != null) {
            buf.append("</").append(this.tagName).append(">");
        }
        return buf;
    }

    public int getNodeType() {
        return this.isDocumentNode() ? 9 : 1;
    }
}

