/*
 * Decompiled with CFR 0.152.
 */
package feat2.validation;

import feat2.StringUtil;
import feat2.validation.SingleValueValidator;
import feat2.validation.ValidatorUtil;
import java.util.Map;

public class StringValidator
implements SingleValueValidator {
    public static final String ASCII = "ascii";
    public static final String NUMBER = "number";
    public static final String FULL_WIDTH_NUMBER = "full-width-number";
    public static final String ALPHABET = "alphabet";
    public static final String FULL_WIDTH_ALPHABET = "full-width-alphabet";
    public static final String HIRAGANA = "hiragana";
    public static final String KATAKANA = "katakana";
    public static final String HALF_WIDTH_KATAKANA = "half-width-katakana";
    public static final String WHITE_SPACE = "white-space";
    private String pattern;
    private String[] charRange;

    public boolean validate(String value) {
        if (ValidatorUtil.isBlankOrNull(value)) {
            return true;
        }
        if (this.pattern != null && !value.matches(this.pattern)) {
            return false;
        }
        if (this.charRange != null) {
            StringBuffer range = new StringBuffer("^[");
            for (int i = 0; i < this.charRange.length; ++i) {
                String rangeName = this.charRange[i];
                if (rangeName.equals(ASCII)) {
                    range.append("\\x00-\\x7f");
                    continue;
                }
                if (rangeName.equals(NUMBER)) {
                    range.append("0-9");
                    continue;
                }
                if (rangeName.equals(FULL_WIDTH_NUMBER)) {
                    range.append("\uff10-\uff19");
                    continue;
                }
                if (rangeName.equals(ALPHABET)) {
                    range.append("a-zA-Z");
                    continue;
                }
                if (rangeName.equals(FULL_WIDTH_ALPHABET)) {
                    range.append("\uff41-\uff5a\uff21-\uff3a");
                    continue;
                }
                if (rangeName.equals(HIRAGANA)) {
                    range.append("\\u3041-\\u309e");
                    continue;
                }
                if (rangeName.equals(KATAKANA)) {
                    range.append("\\u30a1-\\u30fe");
                    continue;
                }
                if (rangeName.equals(HALF_WIDTH_KATAKANA)) {
                    range.append("\\uff65-\\uff9f");
                    continue;
                }
                if (!rangeName.equals(WHITE_SPACE)) continue;
                range.append("\\s\u3000");
            }
            if (range.length() >= 2) {
                range.append("]+$");
                if (!value.matches(range.toString())) {
                    return false;
                }
            }
        }
        return true;
    }

    public String getDefaultMessageId() {
        return "error.validation.string";
    }

    public Map getKeyrowds() {
        return null;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String[] getCharRanges() {
        return this.charRange;
    }

    public void setCharRange(String charRange) {
        this.charRange = StringUtil.split(charRange);
    }
}

