﻿/*
 * $Revision: 223 $ $Date: 2007-10-14 17:07:40 +0900 $
 * Copyright (C) 2004-2005 SUGIMOTO Ken-ichi
 */

import feat2.*;

class feat2.XMLReader {

    static function read(doc:XMLNode, factory:ObjectFactory):Object {
        var reader:XMLReader = new XMLReader(factory);
        return reader.start(doc);
    }

    private var factory:ObjectFactory;
    private var stack:Array;
    private var type:Array;
    private var sp:Number;

    function XMLReader(factory:ObjectFactory) {
        this.factory = factory;
        stack = new Array();
        type = new Array();
        sp = 0;
    }

    function start(doc:XMLNode):Object {
        var cur:XMLNode = doc;
        var skipChild:Boolean = false;

        while(true) {

            // 次のノードへ移動

            if ( cur.hasChildNodes() && !skipChild ) {
                // 子ノートがあれば子ノードへ移動
                cur = cur.firstChild;
            }
            else {
                skipChild = false;
                if ( cur.nextSibling != null ) {
                    // 次の兄弟ノードがあれば移動
                    endElement(cur);
                    cur = cur.nextSibling;
                }
                else if ( cur.parentNode != null ) {
                    // 親ノードがあれば移動
                    endElement(cur);
                    cur = cur.parentNode;
                    // 再び同じノードへ戻ってこないように
                    // 子ノードをスキップするフラグを立てる
                    // これは親の兄弟ノードへの移動をするために必要
                    skipChild = true;
                    continue;
                }
                else {
                    break;
                }
            }

            if ( cur.nodeType == 1 ) {
                startElement(cur);
            }
        }
        return stack[0];
    }

    private function startElement(n:XMLNode):Void {
        //trace("startElement nodeName:"+n.nodeName+" name:"+n.attributes.name+" class:"+n.attributes["class"]);

        if ( n.nodeName == "property" ) {
            var o = null;
            var value:String = n.firstChild.nodeValue;
            if ( n.attributes.isNull ) {
                value = null;
            }
            if ( n.attributes.type == "boolean" ) {
                o = new Boolean(value == "true");
            }
            else if ( n.attributes.type == "number" ) {
                o = new Number(value);
            }
            else if ( n.attributes.type == "string" ) {
                if ( value == null )
                    o = null;
                else
                    o = value;
            }
            else if ( n.attributes.type == "date" ) {
                if ( value == null ) {
                    o = null;
                }
                else {
                    var d = value.split(".");
                    o = new Date(d[0], d[1], d[2], d[3], d[4], d[5], d[6]);
                }
            }
            var co:Object = getCurrentObject();
            if ( co == null ) {
                stack[sp] = o;
                type[sp] = n.attributes.type;
                sp++;
            }
            else {
                co[n.attributes.name] = o;
            }
        }
        else if ( n.nodeName == "object" ) {
            var o:Object = null;
            // factoryがあればfactoryにオブジェクトを作らせる
            if ( factory != null ) {
                o = factory.createObject(n.attributes["type"]);
                _root.debug("[XMLReader#startElement] create object - type:"+n.attributes["type"]);
            }
            // factoryがない、もしくはfactoryがオブジェクトを作れなかったらObjectを作る
            if ( o == null ) {
                o = new Object();
            }
            setObject(n.attributes.name, o);
            stack[sp] = o;
            type[sp] = "object";
            sp++;
        }
        else if ( n.nodeName == "list" ) {
            var o:Object = new Array();
            setObject(n.attributes.name, o);
            stack[sp] = o;
            type[sp] = "list";
            sp++;
        }
    }

    private function endElement(n:XMLNode):Void {
        if ( n.nodeType == 1 ) {
            //trace("endElement nodeName:"+n.nodeName);
            if ( sp > 0 && n.nodeName != "property" ) {
                sp--;
            }
        }
    }

    private function setObject(prop:String, o:Object):Void {
        var co:Object = getCurrentObject();
        var ct:String = getCurrentType();
        if ( co != null ) {
            if ( ct == "object" ) {
                co[prop] = o;
            }
            else if ( ct == "list" ) {
                var list = co; // 型をごまかす
                list.push(o);
            }
        }
    }

    private function getCurrentObject():Object {
        if ( sp > 0 )
            return stack[sp-1];
        else
            return null;
    }

    private function getCurrentType():String {
        if ( sp > 0 )
            return type[sp-1];
        else
            return null;
    }


}
