/*
 * $Id: HTMLRemark.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 作成日: 2005/07/24
 */
package feat2.template;

/**
 * HTMLのコメント。
 * @author SUGIMOTO Ken-ichi
 */
public interface HTMLRemark extends HTMLNode {

    /**
     * 注釈のテキストを設定する。
     * @param text
     * @throws RemarkTextException テキストの中に"--"が含まれている
     */
    public void setText(String text) throws RemarkTextException;

    public String getText();

    /**
     * 注釈のテキストを追加する。
     * @param text
     * @throws RemarkTextException テキストの中に"--"が含まれている
     */
    public void addText(String text) throws RemarkTextException;
}