/*
 * $Id: NodeListIterator.java 220 2007-07-16 10:32:15Z sugimotokenichi $
 * Copyright (C) 2005 SUGIMOTO Ken-ichi
 * 作成日: 2005/10/29
 */
package feat2.template;

import java.util.NoSuchElementException;

import feat2.template.impl.HTMLNodeImpl;

/**
 * ノードの兄弟ノードをたどるイテレータ。
 * @author SUGIMOTO Ken-ichi
 */
public class NodeListIterator implements NodeIterator {

    private HTMLNode current;
    private HTMLNode next;
    private HTMLNode currentBak;
    private HTMLNode nextBak;

    /**
     *
     * @param start 開始点となるノード。
     */
    public NodeListIterator(HTMLNode start) {
        nextBak = next = start;
    }

    public void remove() {
        if ( current == null ) {
            throw new IllegalStateException();
        }
        else {
            current.detach();
            current = null;
        }
    }

    public boolean hasNext() {
        return next != null;
    }

    public Object next() {
        if ( next == null )
            throw new NoSuchElementException();

        // current, nextの内容を1つ進める
        current = next;
        next = ((HTMLNodeImpl)next).next;

        return current;
    }

    public HTMLNode nextNode() {
        return (HTMLNode)next();
    }

    public void mark() {
        currentBak = current;
        nextBak = next;
    }

    public void reset() {
        current = currentBak;
        next = nextBak;
    }

    public boolean skip(Object o) {
        HTMLNode c = current;
        HTMLNode n = next;
        while(hasNext()) {
            if ( next() == o )
                return true;
        }
        current = c;
        next = n;
        return false;
    }


}
